package com.clustercontrol.cloud.registry;

import com.clustercontrol.cloud.PluginFault;



public interface IObjectChangedService {
	<T> void addObjectChangedListener(String type, Class<T> clazz, IObjectChangedListener<T> listener);
	<T> void removeObjectChangedListener(String type, Class<T> clazz, IObjectChangedListener<T> listener);

	<T> void firePreAddedEvent(String type, Class<T> clazz, T object) throws PluginFault;
	<T> void firePostAddedEvent(String type, Class<T> clazz, T object) throws PluginFault;
	<T> void firePreRemovedEvent(String type, Class<T> clazz, T object) throws PluginFault;
	<T> void firePreModifiedEvent(String type, Class<T> clazz, T object) throws PluginFault;
	<T> void firePostModifiedEvent(String type, Class<T> clazz, T object) throws PluginFault;
}
