package com.clustercontrol.cloud.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

import com.clustercontrol.accesscontrol.bean.ObjectPrivilegeFilterInfo;
import com.clustercontrol.accesscontrol.bean.ObjectPrivilegeInfo;
import com.clustercontrol.accesscontrol.bean.RoleInfo;
import com.clustercontrol.accesscontrol.bean.RoleTreeItem;
import com.clustercontrol.accesscontrol.bean.SystemPrivilegeInfo;
import com.clustercontrol.accesscontrol.bean.UserInfo;
import com.clustercontrol.accesscontrol.session.AccessControllerBean;
import com.clustercontrol.cloud.InternalManagerError;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.persistence.TransactionException;
import com.clustercontrol.fault.FacilityDuplicate;
import com.clustercontrol.fault.FacilityNotFound;
import com.clustercontrol.fault.HinemosUnknown;
import com.clustercontrol.fault.InvalidRole;
import com.clustercontrol.fault.InvalidSetting;
import com.clustercontrol.fault.InvalidUserPass;
import com.clustercontrol.fault.JobMasterNotFound;
import com.clustercontrol.fault.PrivilegeDuplicate;
import com.clustercontrol.fault.RoleDuplicate;
import com.clustercontrol.fault.RoleNotFound;
import com.clustercontrol.fault.UnEditableRole;
import com.clustercontrol.fault.UnEditableUser;
import com.clustercontrol.fault.UsedFacility;
import com.clustercontrol.fault.UsedObjectPrivilege;
import com.clustercontrol.fault.UsedOwnerRole;
import com.clustercontrol.fault.UsedRole;
import com.clustercontrol.fault.UsedUser;
import com.clustercontrol.fault.UserDuplicate;
import com.clustercontrol.fault.UserNotFound;

public class AccessControllerBeanWrapper extends AccessControllerBean {
	private static ThreadLocal<AccessControllerBeanWrapper> instance  = new ThreadLocal<AccessControllerBeanWrapper>() {
		protected AccessControllerBeanWrapper initialValue()
		{
			return null;
		}
	};

	private  <T> T execute(Callable<T> task) throws Exception {
		return HinemosUtil.submit(task).get();
	}

	public static AccessControllerBeanWrapper bean() {
		AccessControllerBeanWrapper bean = instance.get();
		if (bean == null) {
			bean = new AccessControllerBeanWrapper();
			instance.set(bean);
		}
		return bean;
	}

	@Override
	public void checkLogin() {
		throw new UnsupportedOperationException();
	}

	@Override
	public ArrayList<UserInfo> getUserInfoList() throws HinemosUnknown {
		throw new UnsupportedOperationException();
	}

	@Override
	public UserInfo getOwnUserInfo() throws HinemosUnknown {
		throw new UnsupportedOperationException();
	}

	@Override
	public UserInfo getUserInfo(String userId) throws HinemosUnknown {
		throw new UnsupportedOperationException();
	}

	@Override
	public void getUserInfoByPassword(String username, String password,
			ArrayList<SystemPrivilegeInfo> systemPrivilegeList)
			throws InvalidUserPass, InvalidRole, HinemosUnknown {
		throw new UnsupportedOperationException();
	}

	@Override
	public void addUserInfo(UserInfo info) throws HinemosUnknown,
			UserDuplicate, InvalidSetting {
		throw new UnsupportedOperationException();
	}

	@Override
	public void modifyUserInfo(UserInfo info) throws HinemosUnknown,
			UserNotFound, UnEditableUser, InvalidSetting {
		throw new UnsupportedOperationException();
	}

	@Override
	public void deleteUserInfo(String userId) throws HinemosUnknown,
			UserNotFound, UsedUser, UnEditableUser {
		throw new UnsupportedOperationException();
	}

	@Override
	public void changeOwnPassword(String password) throws HinemosUnknown,
			UserNotFound {
		throw new UnsupportedOperationException();
	}

	@Override
	public void changePassword(String userId, String password)
			throws HinemosUnknown, UserNotFound {
		throw new UnsupportedOperationException();
	}

	@Override
	public boolean isAdministrator() throws HinemosUnknown {
		throw new UnsupportedOperationException();
	}

	@Override
	public boolean isPermission(SystemPrivilegeInfo systemPrivilege)
			throws HinemosUnknown {
		throw new UnsupportedOperationException();
	}

	@Override
	public String getUserName() throws HinemosUnknown, UserNotFound {
		throw new UnsupportedOperationException();
	}

	@Override
	public String getVersion() {
		throw new UnsupportedOperationException();
	}

	@Override
	public ArrayList<String> getOwnerRoleIdList() throws HinemosUnknown {
		throw new UnsupportedOperationException();
	}

	@Override
	public ArrayList<RoleInfo> getRoleInfoList() throws HinemosUnknown {
		throw new UnsupportedOperationException();
	}

	@Override
	public RoleInfo getRoleInfo(final String roleId) throws HinemosUnknown {
		try {
			return execute(new Callable<RoleInfo>() {
				@Override
				public RoleInfo call() throws Exception {
					AccessControllerBean accessBean = new AccessControllerBean();
					return accessBean.getRoleInfo(roleId);
				}
			});
		}
		catch (InterruptedException e) { 
			throw new InternalManagerError(e);
		}
		catch (ExecutionException e) {
			// めんどくさいが、以下のように ExecutionException を含めて例外をラップしないと、
			// ExecutionException 分の例外が途切れる
			if (e.getCause() instanceof HinemosUnknown) {
				throw new HinemosUnknown(e.getCause().getMessage());
			}
			else {
				throw new InternalManagerError(e);
			}
		} catch (Exception e) {
			throw new InternalManagerError(e);
		}
	}

	@Override
	public void addRoleInfo(RoleInfo roleInfo) throws RoleDuplicate,
			FacilityDuplicate, InvalidSetting, InvalidRole, HinemosUnknown {
		throw new UnsupportedOperationException();
	}

	@Override
	public void modifyRoleInfo(RoleInfo roleInfo) throws InvalidSetting,
			InvalidRole, RoleNotFound, UnEditableRole, FacilityNotFound,
			HinemosUnknown {
		throw new UnsupportedOperationException();
	}

	@Override
	public void deleteRoleInfo(String roleId) throws UsedFacility,
			RoleNotFound, UnEditableRole, UsedRole, UsedOwnerRole,
			FacilityNotFound, InvalidRole, HinemosUnknown {
		throw new UnsupportedOperationException();
	}

	@Override
	public RoleTreeItem getRoleTree(Locale locale) throws HinemosUnknown,
			UserNotFound, InvalidRole {
		throw new UnsupportedOperationException();
	}

	@Override
	public ArrayList<SystemPrivilegeInfo> getSystemPrivilegeInfoList()
			throws HinemosUnknown {
		throw new UnsupportedOperationException();
	}

	@Override
	public ArrayList<SystemPrivilegeInfo> getSystemPrivilegeInfoListByRoleId(
			String roleId) throws HinemosUnknown {
		throw new UnsupportedOperationException();
	}

	@Override
	public ArrayList<SystemPrivilegeInfo> getSystemPrivilegeInfoListByUserId(
			String userId) throws HinemosUnknown {
		throw new UnsupportedOperationException();
	}

	@Override
	public void assignUserRole(String roleId, String[] userIds)
			throws UnEditableRole, HinemosUnknown {
		throw new UnsupportedOperationException();
	}

	@Override
	public void replaceSystemPrivilegeRole(String roleId,
			List<SystemPrivilegeInfo> systemPrivileges) throws UnEditableRole,
			HinemosUnknown {
		throw new UnsupportedOperationException();
	}

	@Override
	public ArrayList<ObjectPrivilegeInfo> getObjectPrivilegeInfoList(final ObjectPrivilegeFilterInfo filter) throws HinemosUnknown {
		try {
			return execute(new Callable<ArrayList<ObjectPrivilegeInfo>>() {
				@Override
				public ArrayList<ObjectPrivilegeInfo> call() throws Exception {
					return new AccessControllerBean().getObjectPrivilegeInfoList(filter);
				}
			});
		}
		catch (InterruptedException e) { 
			throw new InternalManagerError(e);
		}
		catch (ExecutionException e) {
			// めんどくさいが、以下のように ExecutionException を含めて例外をラップしないと、
			// ExecutionException 分の例外が途切れる
			if (e.getCause() instanceof HinemosUnknown) {
				throw new HinemosUnknown(e.getCause().getMessage(), e);
			}
			else {
				throw new InternalManagerError(e);
			}
		} catch (Exception e) {
			throw new InternalManagerError(e);
		}
	}

	@Override
	public ObjectPrivilegeInfo getObjectPrivilegeInfo(String objectType,
			String objectId, String roleId, String objectPrivilege)
			throws HinemosUnknown {
		throw new UnsupportedOperationException();
	}

	@Override
	public void replaceObjectPrivilegeInfo(final String objectType, final String objectId, final List<ObjectPrivilegeInfo> list) throws PrivilegeDuplicate, UsedObjectPrivilege, HinemosUnknown, InvalidSetting, InvalidRole, JobMasterNotFound {
		try {
			SessionService.RolebackAction rolebackAction = execute(new Callable<SessionService.RolebackAction>() {
				@Override
				public SessionService.RolebackAction call() throws Exception {
					AccessControllerBean accessBean = new AccessControllerBean();

					ObjectPrivilegeFilterInfo filter = new ObjectPrivilegeFilterInfo();
					filter.setObjectId(objectId);
					filter.setObjectType(objectType);
					final List<ObjectPrivilegeInfo> result = accessBean.getObjectPrivilegeInfoList(filter);

					accessBean.replaceObjectPrivilegeInfo(objectType, objectId, list);
					
					SessionService.RolebackAction rolebackAction = new SessionService.RolebackAction() {
						@Override
						public void rollback() throws TransactionException {
							try {
								execute(new Callable<Object>() {
									@Override
									public Object call() throws Exception {
										new AccessControllerBean().replaceObjectPrivilegeInfo(objectType, objectId, result);
										return null;
									}
								});
							}
							catch (Exception e) {
								throw new TransactionException(e);
							}
						}
					};
					
					return rolebackAction;
				}
			});
			SessionService.current().addRollbackAction(rolebackAction);
		}
		catch (InterruptedException e) { 
			throw new InternalManagerError(e);
		}
		catch (ExecutionException e) {
			// めんどくさいが、以下のように ExecutionException を含めて例外をラップしないと、
			// ExecutionException 分の例外が途切れる
			if (e.getCause() instanceof PrivilegeDuplicate) {
				throw new PrivilegeDuplicate(e.getCause().getMessage(), e);
			}
			else if (e.getCause() instanceof UsedObjectPrivilege) {
				throw new UsedObjectPrivilege(e.getCause().getMessage());
			}
			else {
				throw new InternalManagerError(e);
			}
		} catch (Exception e) {
			throw new InternalManagerError(e);
		}
	}
}
