package com.clustercontrol.cloud.util;

import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DebugUtil {
	//受け取ったオブジェクトの引数無しのゲットメソッドの名称と結果をコンソールに出力します。
	public static void printObject(Object obj){
		System.out.println("printing props of " + obj.getClass().getSimpleName() + "...");
		recursive(obj, null);
	}

	//受け取ったオブジェクトの引数無しのゲットメソッドの名称と結果をコンソールに出力します。
	private static void recursive(Object obj, String prefix){
		Pattern p = Pattern.compile("^(get|is)(.+)$");
		for (Method method: obj.getClass().getMethods()) {
			if (method.getReturnType() == Class.class) {
				continue;
			}

			if (method.getReturnType() == Void.class || method.getParameterTypes().length != 0 || (!method.getName().startsWith("get") && !method.getName().startsWith("is"))) {
				continue;
			}
			
			String propName = null;
			Matcher m = p.matcher(method.getName());
			if (m.matches()) {
				propName = m.group(2);
				propName = propName.substring(0,1).toLowerCase() + propName.substring(1);
			}
			else {
				continue;
			}
			
			try {
				String qualifiedPropName = prefix != null ? prefix + "." + propName: propName;
				if (method.getReturnType() == Long.class && (propName.toLowerCase().contains("date") || propName.toLowerCase().contains("time"))) {
					System.out.println("\t" + qualifiedPropName + " " + new Date((Long)method.invoke(obj, new Object[0])).toString());
				}
				else if (method.getReturnType().isPrimitive() || Number.class.isAssignableFrom(method.getReturnType()) || method.getReturnType() == Boolean.class || method.getReturnType() == String.class || method.getReturnType() == Date.class  || Enum.class.isAssignableFrom(method.getReturnType())) {
					System.out.println("\t" + qualifiedPropName + " " + method.invoke(obj, new Object[0]));
				}
				else if (method.getReturnType() == List.class) {
					List<?> list = (List<?>)method.invoke(obj, new Object[0]);
					if (list.isEmpty()) {
						recursive(list, qualifiedPropName);
					}
					else {
						for (int i = 0; i < list.size(); ++i) {
							recursive(list.get(i), qualifiedPropName + "[" + i + "]");
						}
					}
				}
				else {
					Object prop = method.invoke(obj, new Object[0]);
					if (prop == null) {
						System.out.println("\t" + propName + " " + null);
					}
					else {
						recursive(prop, qualifiedPropName);
					}
				}
			}
			catch (Exception e) {
				e.printStackTrace();
			}
		}
	}
}
