package com.clustercontrol.cloud.validation;

import java.lang.reflect.Method;
import java.util.Map;

import com.clustercontrol.cloud.IMessagesHolder;

public interface EntityValidator {
	public interface PropValidatorInfo {
		String propName();
		String elementId();
		Method getMethod();
		void validate(Object property, String group, IMessagesHolder messages) throws ValidationFault;
	}

	public interface EntityValidationContext {
		Class<?> ｔype();
		void validate(Object entity, String group, IMessagesHolder messages) throws ValidationFault;
		PropValidatorInfo getPropValidator(String propName);
		Map<String, PropValidatorInfo> getPropValidatorMap();
		CustomEntityValidator<?> getCustomEntityValidator();
	}

	void validate(Object entity, String group) throws ValidationFault;

//	EntityContext getEntityContext(Class<?> type);
}
