package com.clustercontrol.cloud.validation;

import java.lang.reflect.Method;

import com.clustercontrol.cloud.IMessagesHolder;

public interface MethodValidator {
	public interface ParamValidatorInfo {
		void validate(Object parameter, String group, IMessagesHolder messages) throws ValidationFault;
	}

	public interface MethodValidationContext {
		Method method();
		String validationGroup();
		void validate(Object[] params, IMessagesHolder messages) throws ValidationFault;
		ParamValidatorInfo[] getPropValidators();
		CustomMethodValidator[] getCustomMethodValidators();
	}

	void validate(Method method, Object[] params) throws ValidationFault;

	MethodValidationContext getMethodContext(Method method);
}
