package com.clustercontrol.cloud.validation.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(RetentionPolicy.RUNTIME)  
@Target(ElementType.METHOD)
@ValidatedBy(com.clustercontrol.cloud.validation.ValidationUtil.IntRangeValidator.class)
public @interface IntRange {
	String elementId() default "";
	long min() default Long.MIN_VALUE;
	long max() default Long.MAX_VALUE;
	String validationId() default "com.clustercontrol.cloud.validation.annotation.IntRange";
	String[] groups() default {};
}
