package com.clustercontrol.cloud;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import com.clustercontrol.plugin.api.HinemosPlugin;

public abstract class CloudPlugin implements HinemosPlugin {
	private static Map<String, CloudPlugin> pluginMap = Collections.synchronizedMap(new HashMap<String, CloudPlugin>());
	
	public CloudPlugin() {
		pluginMap.put(getPluginId(), this);
	}
	
	public abstract String getPluginId();
	// HinemosPlugin の　create の呼び出しが依存関係の順番を考慮していない。
	// この関数は、activate の呼び出し前に依存関係を考慮して呼び出される。
	public abstract void initialize();
	
	public Map<String, CloudPlugin> getPluginMap() {
		synchronized (pluginMap) {
			return new HashMap<>(pluginMap);
		}
	}
}
