package com.clustercontrol.cloud;


public interface IUserManagement {
	public interface ICredential {
	    public String getAccessKey();
	    public String getSecretKey();
	}

	public static class Credential implements ICredential{
		private String accessKey;
		private String secretKey;
		
		public Credential(String accessKey, String secretKey) {
			this.accessKey = accessKey;
			this.secretKey = secretKey;
		}
	    public String getAccessKey() {
	    	return accessKey;
	    }
	    public String getSecretKey() {
	    	return secretKey;
	    }
	}

	public static class User {
		public static enum UserKind {
			account,
			user
		}
		private String name;
		private UserKind kind;

		public User(String name, UserKind kind) {
			this.name = name;
			this.kind = kind;
		}
		
		public String getName() {
			return name;
		}
		public void setName(String name) {
			this.name = name;
		}
		public UserKind getKind() {
			return kind;
		}
		public void setKind(UserKind kind) {
			this.kind = kind;
		}
	}

	void setCredential(ICredential credential);
	
	// ユーザー
	User getCurrentUser() throws CloudManagerFault;
}
