package com.clustercontrol.cloud.bean;

import java.io.Serializable;
import java.sql.Timestamp;

import javax.xml.bind.annotation.XmlTransient;

import com.clustercontrol.cloud.dao.CloudAccountResourceDao;
import com.clustercontrol.cloud.validation.annotation.ReadOnly;

public class CloudAccountResource implements Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = 8363096469399438827L;

	private CloudAccountResourceDao dao;
	private String accountId;

	public CloudAccountResource() {
		this.dao = new CloudAccountResourceDao();
	}
	
	public CloudAccountResource(CloudAccountResourceDao dao) {
		this.dao = dao;
		this.accountId = dao.getAccount() == null ? null: dao.getAccount().getCloudUserId();
	}
	
	public String getAccountResourceId() {
		return dao.getAccountResourceId();
	}
	
	public void setAccountResourceId(String accountResourceId) {
		dao.setAccountResourceId(accountResourceId);
	}

	public String getAccountResourceName() {
		return dao.getAccountResourceName();
	}
	
	public void setAccountResourceName(String accountResourceName) {
		dao.setAccountResourceName(accountResourceName);
	}
	
	public String getAccountId() {
		return accountId;
	}
	
	public void setAccountId(String accountId) {
		this.accountId = accountId;
	}

	public String getCloudServiceId() {
		return dao.getCloudServiceId();
	}
	
	public void setCloudServiceId(String cloudServiceId) {
		dao.setCloudServiceId(cloudServiceId);
	}

	public Boolean isBillingDetailCollectorFlg() {
		return dao.getBillingDetailCollectorFlg();
	}
	
	public void setBillingDetailCollectorFlg(Boolean bllingDetailCollectorFlg) {
		dao.setBillingDetailCollectorFlg(bllingDetailCollectorFlg);
	}

	public Integer getRetentionPeriod() {
		return dao.getRetentionPeriod();
	}
	
	public void setRetentionPeriod(Integer retentionPeriod) {
		dao.setRetentionPeriod(retentionPeriod);
	}
	
	public String getDescription() {
		return dao.getDescription();
	}
	
	public void setDescription(String description) {
		dao.setDescription(description);
	}
	/**
	 * 登録日を取得します。
	 * 
	 * @return 登録日。
	 */
	@ReadOnly
	public Long getRegDate() {
		return dao.getRegDate() != null ? dao.getRegDate().getTime(): null;
	}

	/**
	 * 登録日を指定します。参照時のみ有効となるので使用しません。
	 * 
	 * @param regDate 登録日。
	 */
	public void setRegDate(Long regDate) {
		if (regDate == null) {
			dao.setRegDate(null);
		}
		else {
			dao.setRegDate(new Timestamp(regDate));
		}
	}

	/**
	 * 更新日を取得します。
	 * 
	 * @return 更新日。
	 */
	@ReadOnly
	public Long getUpdateDate() {
		return dao.getUpdateDate() != null ? dao.getUpdateDate().getTime(): null;

	}

	/**
	 * 更新日を指定します。参照時のみ有効となるので使用しません。
	 * 
	 * @param updateDate 更新日。
	 */
	public void setUpdateDate(Long updateDate) {
		if (updateDate == null) {
			dao.setUpdateDate(null);
		}
		else {
			dao.setUpdateDate(new Timestamp(updateDate));
		}
	}
	/**
	 * 登録ユーザーを取得します。
	 * 
	 * @return 登録ユーザー。
	 */
	@ReadOnly
	public String getRegUser() {
		return dao.getRegUser();
	}

	/**
	 * 登録ユーザーを指定します。参照時のみ有効となるので使用しません。
	 * 
	 * @param regUser 登録ユーザー。
	 */
	public void setRegUser(String regUser) {
		dao.setRegUser(regUser);
	}

	/**
	 * 更新ユーザーを取得します。
	 * 
	 * @return 更新ユーザー。
	 */
	@ReadOnly
	public String getUpdateUser() {
		return dao.getUpdateUser();
	}

	/**
	 * 更新ユーザーを指定します。参照時のみ有効となるので使用しません。
	 * 
	 * @param updateUser 更新ユーザー。
	 */
	public void setUpdateUser(String updateUser) {
		dao.setUpdateUser(updateUser);
	}

	@XmlTransient
	public CloudAccountResourceDao getDao() {
		return dao;
	}
}
