package com.clustercontrol.cloud.bean;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import javax.persistence.Transient;

import com.clustercontrol.cloud.dao.CloudEndpointDao;
import com.clustercontrol.cloud.dao.CloudRegionDao;

public class CloudRegion implements Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = 6316558729382606000L;

	private Map<String, CloudEndpoint> endpoints = new HashMap<>();
	
	private CloudRegionDao dao;

	public CloudRegion() {
		dao = new CloudRegionDao();
	}
	
	public CloudRegion(CloudRegionDao dao) {
		this.dao = dao;
		for (CloudEndpointDao d: dao.getEndpoints()) {
			endpoints.put(d.getEndpointType(), new CloudEndpoint(d));
		}
	}
	
	public String getRegion() {
		return dao.getRegion();
	}

	public void setRegion(String region) {
		dao.setRegion(region);
	}

	public String getCloudServiceId() {
		return dao.getCloudServiceId();
	}

	public void setCloudServiceId(String cloudServiceId) {
		this.dao.setCloudServiceId(cloudServiceId);
	}

	public String getDescription() {
		return dao.getDescription();
	}

	public void setDescription(String description) {
		this.dao.setDescription(description);
	}

	public String getRegionName() {
		return dao.getRegionName();
	}

	public void setRegionName(String regionName) {
		this.dao.setRegionName(regionName);
	}
	
	@Transient
	public CloudEndpoint getEndpoint(String type) {
		return endpoints.get(type);
	}
}
