/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.bean;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlType;

import com.clustercontrol.cloud.IResourceManagement;
import com.clustercontrol.cloud.dao.CloudStorageBackupDao;

public class CloudStorageBackup implements Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = -8678083533091144224L;
	
	@XmlType(name="StorageBackupedData")
	public static class BackupedData implements Serializable {
		/**
		 * 
		 */
		private static final long serialVersionUID = 4917927838640936415L;

		private CloudStorageBackupDao.BackupedData dao;
		private IResourceManagement.StorageBackup.BackupedData backup;

		public BackupedData(CloudStorageBackupDao.BackupedData dao, IResourceManagement.StorageBackup.BackupedData backup) {
			this.dao = dao;
			this.backup = backup;
		}
		
		public BackupedData() {
			this.dao = new CloudStorageBackupDao.BackupedData();
		}

		public String getStorageId() {
			return dao.getStorageId();
		}

		public void setStorageId(String storageId) {
			throw new UnsupportedOperationException();
		}
		
		public String getFlavor() {
			return backup != null ? backup.getFlavor(): null;
		}

		public void setFlavor(String flavor) {
			throw new UnsupportedOperationException();
		}

		public String getZone() {
			return backup != null ? backup.getZone(): null;
		}

		public void setZone(String zone) {
			throw new UnsupportedOperationException();
		}

		public int getSize() {
			return backup != null ? backup.getSize(): null;
		}
		public void setSize(int size) {
			throw new UnsupportedOperationException();
		}

		public String getStorageDetail() {
			return backup != null ? backup.getStorageDetail(): null;
		}
		public void setStorageDetail(String storageDetail) {
			throw new UnsupportedOperationException();
		}
	}
	
	private CloudStorageBackupDao dao;
	private IResourceManagement.StorageBackup backup;

	public CloudStorageBackup() {
		super();
	}

	public CloudStorageBackup(CloudStorageBackupDao dao, IResourceManagement.StorageBackup backup) {
		super();
		this.dao = dao;
		this.backup = backup;
	}

	public String getStorageBackupId() {
		return dao.getStorageBackupId();
	}
	public void setStorageBackupId(String storageBackupId) {
		throw new UnsupportedOperationException();
	}

	public String getRegion() {
		return dao.getRegion();
	}
	public void setRegion(String region) {
		throw new UnsupportedOperationException();
	}
	
	public String getAccountResourceId() {
		return dao.getAccountResourceId();
	}
	public void setAccountResourceId(String accountResourceId) {
		throw new UnsupportedOperationException();
	}

	public String getSnapshotName() {
		return dao.getSnapshotName();
	}
	public void setSnapshotName(String snapshotName) {
		throw new UnsupportedOperationException();
	}

	public String getCloudUserId() {
		return dao.getCloudUserId();
	}
	public void setCloudUserId(String accessKey) {
		throw new UnsupportedOperationException();
	}

	public String getDescription() {
		return dao.getDescription();
	}
	public void setDescription(String description) {
		throw new UnsupportedOperationException();
	}

	public RestoreStatus getRestoreStatus() {
		return RestoreStatus.valueOf(dao.getRestoreStatus().name());
	}

	public void setRestoreStatus(RestoreStatus status) {
		throw new UnsupportedOperationException();
	}

	public BackupedData getBackupedData() {
		return dao.getBackupedData() != null ? new BackupedData(dao.getBackupedData(), backup == null ? null: backup.getBackupedData()): null;
	}
	public void setBackupedData(BackupedData data) {
		throw new UnsupportedOperationException();
	}

	public Long getRegDate() {
		return dao.getRegDate() != null ? dao.getRegDate().getTime(): null;
	}
	public void setRegDate(Long regDate) {
		throw new UnsupportedOperationException();
	}

	public String getRegUser() {
		return dao.getRegUser();
	}

	public void setRegUser(String regUser) {
		throw new UnsupportedOperationException();
	}
}