/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.bean;

import com.clustercontrol.cloud.validation.ModifiableAccountResource;
import com.clustercontrol.cloud.validation.annotation.ElementId;
import com.clustercontrol.cloud.validation.annotation.Identity;
import com.clustercontrol.cloud.validation.annotation.IntRange;
import com.clustercontrol.cloud.validation.annotation.NotNull;


/**
 * インスタンス作成要求に必要な情報を保持するクラス。 
 * {@link com.clustercontrol.ws.cloud.CloudEndpoint#addInstance(CreateCloudAccountResourceRequest request) addInstance 関数} にて使用される。
 *
 */
public class ModifyAccountBillingDetailRequest extends CloudRequest {
	private String accountResourceId;
	private boolean billingDetailCollectorFlg;
	private Integer retentionPeriod;

	public ModifyAccountBillingDetailRequest() {
	}	

	@ElementId("accountResourceId")
	@Identity
	@ModifiableAccountResource
	public String getAccountResourceId() {
		return accountResourceId;
	}
	public void setAccountResourceId(String accountResourceId) {
		this.accountResourceId = accountResourceId;
	}
	
	@ElementId("billingDetailCollectorFlg")
	@NotNull
	public Boolean isBillingDetailCollectorFlg() {
		return billingDetailCollectorFlg;
	}
	public void setBillingDetailCollectorFlg(Boolean billingDetailCollectorFlg) {
		this.billingDetailCollectorFlg = billingDetailCollectorFlg;
	}

	@ElementId("retentionPeriod")
	@NotNull
	@IntRange(min=0, max=180)
	public Integer getRetentionPeriod() {
		return retentionPeriod;
	}

	public void setRetentionPeriod(Integer retentionPeriod) {
		this.retentionPeriod = retentionPeriod;
	}
}
