package com.clustercontrol.cloud.dao;

import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToMany;

import com.fasterxml.jackson.annotation.JsonManagedReference;

//@JsonInclude(JsonInclude.Include.NON_NULL)
@Entity
public class AutoControlResourceDefinitionDao {
	private String name;
	private String displayName;
	private String description;
	private List<OperationDefinitionDao> operations;

	public AutoControlResourceDefinitionDao() {
		super();
	}

	@Id
	@Column
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	@Column
	public String getDisplayName() {
		return displayName;
	}
	public void setDisplayName(String displayName) {
		this.displayName = displayName;
	}
	@Column
	public String getDescription() {
		return description;
	}
	public void setDescription(String description) {
		this.description = description;
	}
	@JsonManagedReference
	@OneToMany(mappedBy="ownerResource")
	public List<OperationDefinitionDao> getOperations() {
		return operations;
	}
	public void setOperations(List<OperationDefinitionDao> operations) {
		this.operations = operations;
	}
}
