/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.dao;

import java.sql.Timestamp;

import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Table;

import com.clustercontrol.cloud.persistence.BooleanTFConverter;

/**
 * 本当は、エンタープライズ側にあるべきクラス<BR>
 * eclipselink の weaving の問題で、CloudManagerBase へ移動。DB のスキーマも CloudManagerBase に含まれる。
 * 
 */
@Entity
@Table(name = "cc_cloud_billing_alarm")
public class BillingAlarmDao extends HinemosObjectDao {
	public static enum MonitorKind {
		delta,
		sum
	}
	
	private String alarmId;
	private String alarmName;
	private String description;
	private String facilityId;
	private String ownerRoleId;
	private MonitorKind monitorKind;
	private Double thresholdInfoLimit;
	private Double thresholdWarnLimit;
	private String unit;
	private String notifyGroupId;
	private Boolean validFlg;
	private String application;
	private Timestamp lastNotifiedDay;

	public BillingAlarmDao(String alarmId, String alarmName, String facilityId,
			String description, String ownerRoleId, MonitorKind monitorKind,
			Double thresholdInfoLimit, Double thresholdWarnLimit, String unit,
			String notifyGroupId, Boolean validFlg, String application, Timestamp regDate, Timestamp updateDate,
			String regUser, String updateUser, Timestamp lastNotifiedDay) {
		super(regDate, updateDate, regUser, updateUser);
		this.alarmId = alarmId;
		this.alarmName = alarmName;
		this.facilityId = facilityId;
		this.description = description;
		this.ownerRoleId = ownerRoleId;
		this.monitorKind = monitorKind;
		this.thresholdInfoLimit = thresholdInfoLimit;
		this.thresholdWarnLimit = thresholdWarnLimit;
		this.unit = unit;
		this.notifyGroupId = notifyGroupId;
		this.validFlg = validFlg;
		this.application = application;
		this.lastNotifiedDay = lastNotifiedDay;
	}

	public BillingAlarmDao(BillingAlarmDao otherData) {
		super(otherData);
		setAlarmId(otherData.getAlarmId());
		setAlarmName(otherData.getAlarmName());
		setFacilityId(otherData.getFacilityId());
		setDescription(otherData.getDescription());
		setOwnerRoleId(otherData.getOwnerRoleId());
		setMonitorKind(otherData.getMonitorKind());
		setThresholdInfoLimit(otherData.getThresholdInfoLimit());
		setThresholdWarnLimit(otherData.getThresholdWarnLimit());
		setUnit(otherData.getUnit());
		setNotifyGroupId(otherData.getNotifyGroupId());
		setValidFlg(otherData.getValidFlg());
		setApplication(otherData.getApplication());
		setLastNotifiedDay(otherData.getLastNotifiedDay());
	}

	public BillingAlarmDao() {
	}

	@Column(name="alarm_id")
	@Id
	public String getAlarmId()
	{
		return this.alarmId;
	}
	public void setAlarmId(String alarmId)
	{
		this.alarmId = alarmId;
	}

	@Column(name="alarm_name")
	public String getAlarmName()
	{
		return this.alarmName;
	}
	public void setAlarmName(String alarmName)
	{
		this.alarmName = alarmName;
	}

	@Column(name="description")
	public String getDescription()
	{
		return this.description;
	}
	public void setDescription(String description)
	{
		this.description = description;
	}

	@Column(name="facility_id")
	public String getFacilityId() {
		return facilityId;
	}
	public void setFacilityId(String facilityId) {
		this.facilityId = facilityId;
	}

	@Convert(converter=BooleanTFConverter.class)
	@Column(name="valid_flg")
	public Boolean getValidFlg()
	{
		return this.validFlg;
	}
	public void setValidFlg(Boolean validFlg)
	{
		this.validFlg = validFlg;
	}

	@Column(name="owner_role_id")
	public String getOwnerRoleId() {
		return ownerRoleId;
	}

	public void setOwnerRoleId(String ownerRoleId) {
		this.ownerRoleId = ownerRoleId;
	}

	@Column(name="monitor_kind")
	@Enumerated(EnumType.STRING)
	public MonitorKind getMonitorKind() {
		return monitorKind;
	}

	public void setMonitorKind(MonitorKind monitorKind) {
		this.monitorKind = monitorKind;
	}

	@Column(name="threshold_info_limit")
	public Double getThresholdInfoLimit() {
		return thresholdInfoLimit;
	}

	public void setThresholdInfoLimit(Double thresholdInfoLimit) {
		this.thresholdInfoLimit = thresholdInfoLimit;
	}

	@Column(name="threshold_warn_limit")
	public Double getThresholdWarnLimit() {
		return thresholdWarnLimit;
	}

	public void setThresholdWarnLimit(Double thresholdWarnLimit) {
		this.thresholdWarnLimit = thresholdWarnLimit;
	}

	@Column(name="unit")
	public String getUnit() {
		return unit;
	}

	public void setUnit(String unit) {
		this.unit = unit;
	}

	@Column(name="notify_group_id")
	public String getNotifyGroupId() {
		return notifyGroupId;
	}

	public void setNotifyGroupId(String notifyGroupId) {
		this.notifyGroupId = notifyGroupId;
	}

	@Column(name="application")
	public String getApplication() {
		return application;
	}

	public void setApplication(String application) {
		this.application = application;
	}

	@Column(name="last_notified_day")
	public Timestamp getLastNotifiedDay() {
		return lastNotifiedDay;
	}

	public void setLastNotifiedDay(Timestamp lastNotifiedDay) {
		this.lastNotifiedDay = lastNotifiedDay;
	}

	@Override
	public Object getId() {
		return getAlarmId();
	}
}