package com.clustercontrol.cloud.dao;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;

/**
 * 本当は、エンタープライズ側にあるべきクラス<BR>
 * eclipselink の weaving の問題で、CloudManagerBase へ移動。DB のスキーマも CloudManagerBase に含まれる。
 * 
 */
@Entity
@Table(name="cc_cloud_billing_detail")
public class BillingDetailDao /*implements IDHolder*/ {
	private Long billingDetailId;
	private String accountResourceId;
	private String accountResourceName;
	private Timestamp targetDate;
	private String category;
	private String categoryDetail;
	private String displayName;
	private Double cost;
	private String unit;
	private List<BillingDetailRelationDao> relations = new ArrayList<>();
	private String resourceId;
	
	public BillingDetailDao() {
	}

	@Id
	@GeneratedValue(strategy=GenerationType.IDENTITY)
	@Column(name="billing_detail_id")
	public Long getBillingDetailId() {
		return billingDetailId;
	}
	public void setBillingDetailId(Long billingDetailId) {
		this.billingDetailId = billingDetailId;
	}
	@Column(name="account_resource_id")
	public String getAccountResourceId() {
		return accountResourceId;
	}
	public void setAccountResourceId(String accountResourceId) {
		this.accountResourceId = accountResourceId;
	}
	@Column(name="account_resource_name")
	public String getAccountResourceName() {
		return accountResourceName;
	}
	public void setAccountResourceName(String accountResourceName) {
		this.accountResourceName = accountResourceName;
	}
	@Column(name="target_date")
	public Timestamp getTargetDate() {
		return targetDate;
	}
	public void setTargetDate(Timestamp targetDate) {
		this.targetDate = targetDate;
	}
	@Column(name="category")
	public String getCategory() {
		return category;
	}
	public void setCategory(String category) {
		this.category = category;
	}
	@Column(name="category_detail")
	public String getCategoryDetail() {
		return categoryDetail;
	}
	public void setCategoryDetail(String categoryDetail) {
		this.categoryDetail = categoryDetail;
	}
	@Column(name="display_name")
	public String getDisplayName() {
		return displayName;
	}
	public void setDisplayName(String displayName) {
		this.displayName = displayName;
	}
	@Column(name="cost")
	public Double getCost() {
		return cost;
	}
	public void setCost(Double cost) {
		this.cost = cost;
	}
	@Column(name="unit")
	public String getUnit() {
		return unit;
	}
	public void setUnit(String unit) {
		this.unit = unit;
	}
	
	@OneToMany(fetch=FetchType.EAGER, mappedBy="billingDetail", cascade={CascadeType.ALL})
	public List<BillingDetailRelationDao> getBillingDetailRelations() {
		return relations;
	}
	public void setBillingDetailRelations(List<BillingDetailRelationDao> relations) {
		this.relations = relations;
	}
	@Column(name="resource_id")
	public String getResourceId() {
		return resourceId;
	}
	public void setResourceId(String resourceId) {
		this.resourceId = resourceId;
	}
	
//	@Override
//	public Integer getId() {
//		return getBillingDetailId();
//	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime
				* result
				+ ((accountResourceId == null) ? 0 : accountResourceId
						.hashCode());
		result = prime
				* result
				+ ((accountResourceName == null) ? 0 : accountResourceName
						.hashCode());
		result = prime * result
				+ ((billingDetailId == null) ? 0 : billingDetailId.hashCode());
		result = prime * result
				+ ((category == null) ? 0 : category.hashCode());
		result = prime * result
				+ ((categoryDetail == null) ? 0 : categoryDetail.hashCode());
		result = prime * result + ((cost == null) ? 0 : cost.hashCode());
		result = prime * result
				+ ((displayName == null) ? 0 : displayName.hashCode());
//		result = prime * result
//				+ ((relations == null) ? 0 : relations.hashCode());
		result = prime * result
				+ ((resourceId == null) ? 0 : resourceId.hashCode());
		result = prime * result
				+ ((targetDate == null) ? 0 : targetDate.hashCode());
		result = prime * result + ((unit == null) ? 0 : unit.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		BillingDetailDao other = (BillingDetailDao) obj;
		if (accountResourceId == null) {
			if (other.accountResourceId != null)
				return false;
		} else if (!accountResourceId.equals(other.accountResourceId))
			return false;
		if (accountResourceName == null) {
			if (other.accountResourceName != null)
				return false;
		} else if (!accountResourceName.equals(other.accountResourceName))
			return false;
		if (billingDetailId == null) {
			if (other.billingDetailId != null)
				return false;
		} else if (!billingDetailId.equals(other.billingDetailId))
			return false;
		if (category == null) {
			if (other.category != null)
				return false;
		} else if (!category.equals(other.category))
			return false;
		if (categoryDetail == null) {
			if (other.categoryDetail != null)
				return false;
		} else if (!categoryDetail.equals(other.categoryDetail))
			return false;
		if (cost == null) {
			if (other.cost != null)
				return false;
		} else if (!cost.equals(other.cost))
			return false;
		if (displayName == null) {
			if (other.displayName != null)
				return false;
		} else if (!displayName.equals(other.displayName))
			return false;
//		if (relations == null) {
//			if (other.relations != null)
//				return false;
//		} else if (!relations.equals(other.relations))
//			return false;
		if (resourceId == null) {
			if (other.resourceId != null)
				return false;
		} else if (!resourceId.equals(other.resourceId))
			return false;
		if (targetDate == null) {
			if (other.targetDate != null)
				return false;
		} else if (!targetDate.equals(other.targetDate))
			return false;
		if (unit == null) {
			if (other.unit != null)
				return false;
		} else if (!unit.equals(other.unit))
			return false;
		return true;
	}

	@Override
	public String toString() {
		return "BillingDetailDao [billingDetailId=" + billingDetailId
				+ ", accountResourceId=" + accountResourceId
				+ ", accountResourceName=" + accountResourceName
				+ ", targetDate=" + targetDate + ", category=" + category
				+ ", categoryDetail=" + categoryDetail + ", displayName="
				+ displayName + ", cost=" + cost + ", unit=" + unit
				+ /*", relations=" + relations + */", resourceId=" + resourceId
				+ "]";
	}

}


//package com.clustercontrol.cloud.dao;
//
//import java.sql.Timestamp;
//
//import javax.persistence.Column;
//import javax.persistence.Entity;
//import javax.persistence.Id;
//import javax.persistence.IdClass;
//import javax.persistence.Table;
//
//import com.clustercontrol.cloud.persistence.IDHolder;
//
///**
// * 本当は、エンタープライズ側にあるべきクラス<BR>
// * eclipselink の weaving の問題で、CloudManagerBase へ移動。DB のスキーマも CloudManagerBase に含まれる。
// * 
// */
//@Entity
//@Table(name="cc_cloud_billing_detail")
//@IdClass(BillingDetailDao.BillingDetailPK.class)
//public class BillingDetailDao implements IDHolder {
//	public static class BillingDetailPK implements java.io.Serializable {
//		/**
//		 * 
//		 */
//		private static final long serialVersionUID = -1965726385131101769L;
//
//		private String accountResourceId;
//		private Timestamp targetDate;
//		private String facilityId;
//		private String category;
//		private String categoryDetail;
//		private String assignFacilityIdList;
//
//		public BillingDetailPK() {
//		}
//
//		public BillingDetailPK(String accountResourceId, Timestamp targetDate,
//				String facilityId, String category, String categoryDetail, String assignFacilityIdList) {
//			super();
//			this.accountResourceId = accountResourceId;
//			this.targetDate = targetDate;
//			this.facilityId = facilityId;
//			this.category = category;
//			this.categoryDetail = categoryDetail;
//			this.assignFacilityIdList = assignFacilityIdList;
//		}
//
//		public String getAccountResourceId() {
//			return accountResourceId;
//		}
//
//		public void setAccountResourceId(String accountResourceId) {
//			this.accountResourceId = accountResourceId;
//		}
//
//		public Timestamp getTargetDate() {
//			return targetDate;
//		}
//
//		public void setTargetDate(Timestamp targetDate) {
//			this.targetDate = targetDate;
//		}
//
//		public String getFacilityId() {
//			return facilityId;
//		}
//
//		public void setFacilityId(String facilityId) {
//			this.facilityId = facilityId;
//		}
//
//		public String getCategory() {
//			return category;
//		}
//
//		public void setCategory(String category) {
//			this.category = category;
//		}
//
//		public String getCategoryDetail() {
//			return categoryDetail;
//		}
//
//		public void setCategoryDetail(String categoryDetail) {
//			this.categoryDetail = categoryDetail;
//		}
//
//		public String getAssignFacilityIdList() {
//			return assignFacilityIdList;
//		}
//
//		public void setAssignFacilityIdList(String assignFacilityIdList) {
//			this.assignFacilityIdList = assignFacilityIdList;
//		}
//
//		@Override
//		public int hashCode() {
//			final int prime = 31;
//			int result = 1;
//			result = prime
//					* result
//					+ ((accountResourceId == null) ? 0 : accountResourceId
//							.hashCode());
//			result = prime
//					* result
//					+ ((assignFacilityIdList == null) ? 0
//							: assignFacilityIdList.hashCode());
//			result = prime * result
//					+ ((category == null) ? 0 : category.hashCode());
//			result = prime
//					* result
//					+ ((categoryDetail == null) ? 0 : categoryDetail.hashCode());
//			result = prime * result
//					+ ((facilityId == null) ? 0 : facilityId.hashCode());
//			result = prime * result
//					+ ((targetDate == null) ? 0 : targetDate.hashCode());
//			return result;
//		}
//
//		@Override
//		public boolean equals(Object obj) {
//			if (this == obj)
//				return true;
//			if (obj == null)
//				return false;
//			if (getClass() != obj.getClass())
//				return false;
//			BillingDetailPK other = (BillingDetailPK) obj;
//			if (accountResourceId == null) {
//				if (other.accountResourceId != null)
//					return false;
//			} else if (!accountResourceId.equals(other.accountResourceId))
//				return false;
//			if (assignFacilityIdList == null) {
//				if (other.assignFacilityIdList != null)
//					return false;
//			} else if (!assignFacilityIdList.equals(other.assignFacilityIdList))
//				return false;
//			if (category == null) {
//				if (other.category != null)
//					return false;
//			} else if (!category.equals(other.category))
//				return false;
//			if (categoryDetail == null) {
//				if (other.categoryDetail != null)
//					return false;
//			} else if (!categoryDetail.equals(other.categoryDetail))
//				return false;
//			if (facilityId == null) {
//				if (other.facilityId != null)
//					return false;
//			} else if (!facilityId.equals(other.facilityId))
//				return false;
//			if (targetDate == null) {
//				if (other.targetDate != null)
//					return false;
//			} else if (!targetDate.equals(other.targetDate))
//				return false;
//			return true;
//		}
//
//		@Override
//		public String toString() {
//			return "BillingDetailPK [accountResourceId=" + accountResourceId
//					+ ", targetDate=" + targetDate + ", facilityId="
//					+ facilityId + ", category=" + category
//					+ ", categoryDetail=" + categoryDetail
//					+ ", assignFacilityIdList=" + assignFacilityIdList + "]";
//		}
//
//	}
//
//	private String accountResourceId;
//	private Timestamp targetDate;
//	private String facilityId;
//	private String facilityName;
//	private String category;
//	private String categoryDetail;
//	private String displayName;
//	private String assignFacilityIdList;
//	private Double cost;
//	private String unit;
//	
//	public BillingDetailDao() {
//	}
//	
//	public BillingDetailDao(String accountResourceId, Timestamp targetDate,
//			String facilityId, String facilityName, String category,
//			String categoryDetail, String displayName,
//			String assignFacilityIdList, Double cost, String unit) {
//		super();
//		this.accountResourceId = accountResourceId;
//		this.targetDate = targetDate;
//		this.facilityId = facilityId;
//		this.facilityName = facilityName;
//		this.category = category;
//		this.categoryDetail = categoryDetail;
//		this.displayName = displayName;
//		this.assignFacilityIdList = assignFacilityIdList;
//		this.cost = cost;
//		this.unit = unit;
//	}
//	@Id
//	@Column(name="account_resource_id")
//	public String getAccountResourceId() {
//		return accountResourceId;
//	}
//	public void setAccountResourceId(String accountResourceId) {
//		this.accountResourceId = accountResourceId;
//	}
//	@Id
//	@Column(name="target_date")
//	public Timestamp getTargetDate() {
//		return targetDate;
//	}
//	public void setTargetDate(Timestamp targetDate) {
//		this.targetDate = targetDate;
//	}
//	@Id
//	@Column(name="facility_id")
//	public String getFacilityId() {
//		return facilityId;
//	}
//	public void setFacilityId(String facilityId) {
//		this.facilityId = facilityId;
//	}
//	@Column(name="facility_name")
//	public String getFacilityName() {
//		return facilityName;
//	}
//	public void setFacilityName(String facilityName) {
//		this.facilityName = facilityName;
//	}
//	@Id
//	@Column(name="category")
//	public String getCategory() {
//		return category;
//	}
//	public void setCategory(String category) {
//		this.category = category;
//	}
//	@Id
//	@Column(name="category_detail")
//	public String getCategoryDetail() {
//		return categoryDetail;
//	}
//	public void setCategoryDetail(String categoryDetail) {
//		this.categoryDetail = categoryDetail;
//	}
//	@Column(name="display_name")
//	public String getDisplayName() {
//		return displayName;
//	}
//	public void setDisplayName(String displayName) {
//		this.displayName = displayName;
//	}
//	@Column(name="assign_facility_id_list")
//	@Id
//	public String getAssignFacilityIdList() {
//		return assignFacilityIdList;
//	}
//	public void setAssignFacilityIdList(String assignFacilityIdList) {
//		this.assignFacilityIdList = assignFacilityIdList;
//	}
//	@Column(name="cost")
//	public Double getCost() {
//		return cost;
//	}
//	public void setCost(Double cost) {
//		this.cost = cost;
//	}
//	@Column(name="unit")
//	public String getUnit() {
//		return unit;
//	}
//	public void setUnit(String unit) {
//		this.unit = unit;
//	}
//
//	@Override
//	public int hashCode() {
//		final int prime = 31;
//		int result = 1;
//		result = prime
//				* result
//				+ ((accountResourceId == null) ? 0 : accountResourceId
//						.hashCode());
//		result = prime
//				* result
//				+ ((assignFacilityIdList == null) ? 0 : assignFacilityIdList
//						.hashCode());
//		result = prime * result
//				+ ((category == null) ? 0 : category.hashCode());
//		result = prime * result
//				+ ((categoryDetail == null) ? 0 : categoryDetail.hashCode());
//		result = prime * result + ((cost == null) ? 0 : cost.hashCode());
//		result = prime * result
//				+ ((displayName == null) ? 0 : displayName.hashCode());
//		result = prime * result
//				+ ((facilityId == null) ? 0 : facilityId.hashCode());
//		result = prime * result
//				+ ((facilityName == null) ? 0 : facilityName.hashCode());
//		result = prime * result
//				+ ((targetDate == null) ? 0 : targetDate.hashCode());
//		result = prime * result + ((unit == null) ? 0 : unit.hashCode());
//		return result;
//	}
//	@Override
//	public boolean equals(Object obj) {
//		if (this == obj)
//			return true;
//		if (obj == null)
//			return false;
//		if (getClass() != obj.getClass())
//			return false;
//		BillingDetailDao other = (BillingDetailDao) obj;
//		if (accountResourceId == null) {
//			if (other.accountResourceId != null)
//				return false;
//		} else if (!accountResourceId.equals(other.accountResourceId))
//			return false;
//		if (assignFacilityIdList == null) {
//			if (other.assignFacilityIdList != null)
//				return false;
//		} else if (!assignFacilityIdList.equals(other.assignFacilityIdList))
//			return false;
//		if (category == null) {
//			if (other.category != null)
//				return false;
//		} else if (!category.equals(other.category))
//			return false;
//		if (categoryDetail == null) {
//			if (other.categoryDetail != null)
//				return false;
//		} else if (!categoryDetail.equals(other.categoryDetail))
//			return false;
//		if (cost == null) {
//			if (other.cost != null)
//				return false;
//		} else if (!cost.equals(other.cost))
//			return false;
//		if (displayName == null) {
//			if (other.displayName != null)
//				return false;
//		} else if (!displayName.equals(other.displayName))
//			return false;
//		if (facilityId == null) {
//			if (other.facilityId != null)
//				return false;
//		} else if (!facilityId.equals(other.facilityId))
//			return false;
//		if (facilityName == null) {
//			if (other.facilityName != null)
//				return false;
//		} else if (!facilityName.equals(other.facilityName))
//			return false;
//		if (targetDate == null) {
//			if (other.targetDate != null)
//				return false;
//		} else if (!targetDate.equals(other.targetDate))
//			return false;
//		if (unit == null) {
//			if (other.unit != null)
//				return false;
//		} else if (!unit.equals(other.unit))
//			return false;
//		return true;
//	}
//	@Override
//	public String toString() {
//		return "BillingDetailDao [accountResourceId=" + accountResourceId
//				+ ", targetDate=" + targetDate + ", facilityId=" + facilityId
//				+ ", facilityName=" + facilityName + ", category=" + category
//				+ ", categoryDetail=" + categoryDetail + ", displayName="
//				+ displayName + ", assignFacilityIdList="
//				+ assignFacilityIdList + ", cost=" + cost + ", unit=" + unit
//				+ "]";
//	}
//	@Override
//	public BillingDetailPK getId() {
//		return new BillingDetailPK(getAccountResourceId(), getTargetDate(), getFacilityId(), getCategory(), getCategoryDetail(), getAssignFacilityIdList());
//	}
//}
