package com.clustercontrol.cloud.dao;

import java.sql.Timestamp;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name="cc_cloud_service")
public class CloudServiceDao extends HinemosObjectDao {
    private String cloudServiceId;
	private String cloudServiceName;
	private String cloudTypeId;
	private String description;

	public CloudServiceDao() {
	}
	
	public CloudServiceDao(String accountResourceId, String accountResourceName, String cloudServiceId, String description, Timestamp regDate, Timestamp updateDate, String regUser, String updateUser) {
		setCloudServiceId(accountResourceId);
		setCloudServiceName(accountResourceName);
		setCloudTypeId(cloudServiceId);
		setDescription(description);
	}

	public CloudServiceDao(CloudServiceDao otherData)
	{
		setCloudServiceId(otherData.getCloudServiceId());
		setCloudServiceName(otherData.getCloudServiceName());
		setCloudTypeId(otherData.getCloudTypeId());
		setDescription(otherData.getDescription());
	}
	
	@Id
	@Column(name="cloud_service_id")
	public String getCloudServiceId() {
		return cloudServiceId;
	}
	
	public void setCloudServiceId(String cloudServiceId) {
		this.cloudServiceId = cloudServiceId;
	}

	@Column(name="cloud_service_name")
	public String getCloudServiceName() {
		return cloudServiceName;
	}
	
	public void setCloudServiceName(String cloudServiceName) {
		this.cloudServiceName = cloudServiceName;
	}
	
	@Column(name="cloud_type_id")
	public String getCloudTypeId() {
		return cloudTypeId;
	}
	
	public void setCloudTypeId(String cloudTypeId) {
		this.cloudTypeId = cloudTypeId;
	}

	@Column(name="description")
	public String getDescription() {
		return description;
	}
	
	public void setDescription(String description) {
		this.description = description;
	}

	public String toString()
	{
		StringBuffer str = new StringBuffer("{");

		str.append("cloudServiceId=" + getCloudServiceId() + " " + "cloudServiceName=" + getCloudServiceName() + " "  + "cloudTypeId=" + getCloudTypeId() + " " + "description=" + getDescription() + " " + super.toString());
		str.append('}');

		return(str.toString());
	}

	public boolean equals( Object pOther )
	{
		if( pOther instanceof CloudServiceDao )
		{
			CloudServiceDao lTest = (CloudServiceDao) pOther;
			boolean lEquals = true;

			if( this.cloudServiceId == null )
			{
				lEquals = lEquals && ( lTest.cloudServiceId == null );
			}
			else
			{
				lEquals = lEquals && this.cloudServiceId.equals( lTest.cloudServiceId );
			}
			if( this.cloudServiceName == null )
			{
				lEquals = lEquals && ( lTest.cloudServiceName == null );
			}
			else
			{
				lEquals = lEquals && this.cloudServiceName.equals( lTest.cloudServiceName );
			}
			if( this.cloudTypeId == null )
			{
				lEquals = lEquals && ( lTest.cloudTypeId == null );
			}
			else
			{
				lEquals = lEquals && this.cloudTypeId.equals( lTest.cloudTypeId );
			}
			if( this.description == null )
			{
				lEquals = lEquals && ( lTest.description == null );
			}
			else
			{
				lEquals = lEquals && this.description.equals( lTest.description );
			}
			
			lEquals = lEquals && super.equals( pOther );

			return lEquals;
		}
		else
		{
			return false;
		}
	}

	public int hashCode()
	{
		int result = super.hashCode();

		result = 37*result + ((this.cloudServiceId != null) ? this.cloudServiceId.hashCode() : 0);

		result = 37*result + ((this.cloudServiceName != null) ? this.cloudServiceName.hashCode() : 0);

		result = 37*result + ((this.cloudTypeId != null) ? this.cloudTypeId.hashCode() : 0);

		result = 37*result + ((this.description != null) ? this.description.hashCode() : 0);

		return result;
	}
	
	@Override
	public String getId() {
		return getCloudServiceId();
	}
}
