package com.clustercontrol.cloud.dao;

import java.sql.Timestamp;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;

import com.clustercontrol.cloud.persistence.ApplyCurrentTime;
import com.clustercontrol.cloud.persistence.ApplyUserName;

@MappedSuperclass
public abstract class HinemosObjectDao extends DaoBase {
	private Timestamp regDate;
	private Timestamp updateDate;
	private java.lang.String regUser;
	private java.lang.String updateUser;

	public HinemosObjectDao()
	{
	}

	public HinemosObjectDao( Timestamp regDate,Timestamp updateDate,java.lang.String regUser,java.lang.String updateUser )
	{
		setRegDate(regDate);
		setUpdateDate(updateDate);
		setRegUser(regUser);
		setUpdateUser(updateUser);
	}

	public HinemosObjectDao( HinemosObjectDao otherData )
	{
		setRegDate(otherData.getRegDate());
		setUpdateDate(otherData.getUpdateDate());
		setRegUser(otherData.getRegUser());
		setUpdateUser(otherData.getUpdateUser());
	}
	
	@Column(name="reg_date")
	@ApplyCurrentTime(onlyPersist=true)
	public Timestamp getRegDate()
	{
		return this.regDate;
	}
	public void setRegDate( Timestamp regDate )
	{
		this.regDate = regDate;
	}

	@Column(name="update_date")
	@ApplyCurrentTime
	public Timestamp getUpdateDate()
	{
		return this.updateDate;
	}
	public void setUpdateDate( Timestamp updateDate )
	{
		this.updateDate = updateDate;
	}

	@Column(name="reg_user")
	@ApplyUserName(onlyPersist=true)
	public java.lang.String getRegUser()
	{
		return this.regUser;
	}
	public void setRegUser( java.lang.String regUser )
	{
		this.regUser = regUser;
	}

	@Column(name="update_user")
	@ApplyUserName
	public java.lang.String getUpdateUser()
	{
		return this.updateUser;
	}
	public void setUpdateUser( java.lang.String updateUser )
	{
		this.updateUser = updateUser;
	}
	
	public String toString()
	{
		StringBuffer str = new StringBuffer("{");

		str.append("regDate=" + getRegDate() + " " + "updateDate=" + getUpdateDate() + " " + "regUser=" + getRegUser() + " " + "updateUser=" + getUpdateUser());

		str.append('}');

		return(str.toString());
	}

	public boolean equals( Object pOther )
	{
		if( pOther instanceof HinemosObjectDao )
		{
			HinemosObjectDao lTest = (HinemosObjectDao) pOther;
			boolean lEquals = true;

			if( this.regDate == null )
			{
				lEquals = lEquals && ( lTest.regDate == null );
			}
			else
			{
				lEquals = lEquals && this.regDate.equals( lTest.regDate );
			}
			if( this.updateDate == null )
			{
				lEquals = lEquals && ( lTest.updateDate == null );
			}
			else
			{
				lEquals = lEquals && this.updateDate.equals( lTest.updateDate );
			}
			if( this.regUser == null )
			{
				lEquals = lEquals && ( lTest.regUser == null );
			}
			else
			{
				lEquals = lEquals && this.regUser.equals( lTest.regUser );
			}
			if( this.updateUser == null )
			{
				lEquals = lEquals && ( lTest.updateUser == null );
			}
			else
			{
				lEquals = lEquals && this.updateUser.equals( lTest.updateUser );
			}

			return lEquals;
		}
		else
		{
			return false;
		}
	}
	
	public int hashCode()
	{
		int result = 17;

		result = 37*result + ((this.getRegDate() != null) ? this.getRegDate().hashCode() : 0);

		result = 37*result + ((this.getUpdateDate() != null) ? this.getUpdateDate().hashCode() : 0);

		result = 37*result + ((this.getRegUser() != null) ? this.getRegUser().hashCode() : 0);

		result = 37*result + ((this.getUpdateUser() != null) ? this.getUpdateUser().hashCode() : 0);

		return result;
	}
}
