package com.clustercontrol.cloud.factory;

import java.util.ArrayList;
import java.util.List;

import javax.persistence.EntityExistsException;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.ErrorCode;
import com.clustercontrol.cloud.Filter;
import com.clustercontrol.cloud.ICloudContext;
import com.clustercontrol.cloud.IResourceManagement;
import com.clustercontrol.cloud.IResourceManagement.IEndpoint;
import com.clustercontrol.cloud.InternalManagerError;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.bean.CloudRegion;
import com.clustercontrol.cloud.bean.CloudService;
import com.clustercontrol.cloud.bean.Zone;
import com.clustercontrol.cloud.dao.CloudRegionDao;
import com.clustercontrol.cloud.dao.CloudServiceDao;
import com.clustercontrol.cloud.persistence.EntityManagerEx;
import com.clustercontrol.cloud.persistence.Transactional;
import com.clustercontrol.cloud.registry.ObjectRegistryService;

@Transactional
public class CloudServiceOperator implements ICloudServiceOperator {
	public CloudServiceOperator() {
	}
	
	@Override
	public CloudService createCloudService(CloudService cs) throws CloudManagerFault {
		CloudServiceDao cud = new CloudServiceDao(cs.getTableData());
		EntityManagerEx em = SessionService.current().getEntityManagerEx();
		try {
			em.persist(cud);
			return new CloudService(cud);
		}
		catch (EntityExistsException e) {
			throw ErrorCode.CLOUDSERVICE_ALREADY_EXIST.cloudManagerFault(cud.getCloudServiceId());
		}
	}

	@Override
	public CloudService modifyCloudService(CloudService cu) throws CloudManagerFault {
		throw new UnsupportedOperationException();
	}

	@Override
	public void removeCloudService(String cloudServiceId) throws CloudManagerFault {
		throw new UnsupportedOperationException();
	}

	@Override
	@Transactional(Transactional.TransactionType.Supported)
	public CloudService findCloudService(String cloudServiceId) throws CloudManagerFault {
		EntityManagerEx em = SessionService.current().getEntityManagerEx();
		CloudServiceDao dao = em.find(CloudServiceDao.class, cloudServiceId);
		if (dao == null) {
			throw ErrorCode.CLOUDSERVICE_INVALID_CLOUDSERVICE_NOT_FOUND.cloudManagerFault(cloudServiceId);
		}
		return new CloudService(dao);
	}

	@Override
	@Transactional(Transactional.TransactionType.Supported)
	public List<CloudService> findAllCloudService() throws CloudManagerFault {
		EntityManagerEx em = SessionService.current().getEntityManagerEx();
		List<CloudServiceDao> csds = em.findAll(CloudServiceDao.class);
		List<CloudService> css = new ArrayList<>();
		for (CloudServiceDao d: csds) {
			css.add(new CloudService(d));
		}
		return css;
	}

	@Override
	public CloudRegion addCloudRegion(String cloudServiceId, CloudRegion cu) throws CloudManagerFault {
		throw new UnsupportedOperationException();
	}

	@Override
	public CloudRegion modifyCloudRegion(String cloudServiceId, CloudRegion cu) throws CloudManagerFault {
		throw new UnsupportedOperationException();
	}

	@Override
	public void removeCloudRegion(String cloudServiceId, String cloudRegionId) throws CloudManagerFault {
		throw new UnsupportedOperationException();
	}

	@Override
	@Transactional(Transactional.TransactionType.Supported)
	public CloudRegion findCloudRegion(String cloudServiceId, String region) throws CloudManagerFault {
		EntityManagerEx em = SessionService.current().getEntityManagerEx();
		CloudRegionDao dao = em.find(CloudRegionDao.class, new CloudRegionDao.CloudRegionPK(cloudServiceId, region));
		if (dao == null) {
			throw ErrorCode.CLOUDREGION_INVALID_CLOUDREGION_NOT_FOUND.cloudManagerFault(cloudServiceId, region);
		}
		return new CloudRegion(dao);
	}

	@Override
	@Transactional(Transactional.TransactionType.Supported)
	public List<CloudRegion> findCloudRegionsByService(String cloudServiceId) throws CloudManagerFault {
		EntityManagerEx em = SessionService.current().getEntityManagerEx();
		List<CloudRegionDao> crds = em.findByFilter(CloudRegionDao.class, new Filter("cloudServiceId", cloudServiceId));
		List<CloudRegion> crs = new ArrayList<>();
		for (CloudRegionDao d: crds) {
			crs.add(new CloudRegion(d));
		}
		return crs;
	}

	@Override
	@Transactional(Transactional.TransactionType.Supported)
	public List<Zone> findZonesByRegion(String cloudServiceId, final String region) throws CloudManagerFault {
		CloudService cloudService = findCloudService(cloudServiceId);
		final CloudRegion cloudRegion = findCloudRegion(cloudServiceId, region);
		
		IResourceManagement rm = ObjectRegistryService.registry().get(IResourceManagement.class, cloudService.getCloudTypeId());
		rm.setAccessDestination(
				new IResourceManagement.ICredential() {
					@Override
					public String getSecretKey() throws CloudManagerFault {
						return SessionService.current().get(ICloudContext.class).getAccessDestionation().getCloudUser().getSecretKey();
					}
					@Override
					public String getAccessKey() throws CloudManagerFault {
						return SessionService.current().get(ICloudContext.class).getAccessDestionation().getCloudUser().getAccessKey();
					}
				},
				new IResourceManagement.IRegion() {
					@Override
					public String getName() {
						return cloudRegion.getRegion();
					}
					@Override
					public IEndpoint getEndpoint(final String type) {
						final String locatio = cloudRegion.getEndpoint(type).getLocation();
						if (locatio != null) {
							return new IEndpoint() {
								@Override
								public String getEndpointType() {
									return type;
								}
								@Override
								public String getLocation() {
									return locatio;
								}
							};
						}
						else {
							throw new InternalManagerError();
						}
					}
				});
		return rm.getZones();
	}
}