package com.clustercontrol.cloud.factory;

import java.util.List;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.bean.CloudRegion;
import com.clustercontrol.cloud.bean.CloudService;
import com.clustercontrol.cloud.bean.Zone;

public interface ICloudServiceOperator {
	// 未使用
	CloudService createCloudService(CloudService cu) throws CloudManagerFault;
	CloudService modifyCloudService(CloudService cu) throws CloudManagerFault;
	void removeCloudService(String cloudServiceId) throws CloudManagerFault;

	CloudService findCloudService(String cloudServiceId) throws CloudManagerFault;
	List<CloudService> findAllCloudService() throws CloudManagerFault;
	
	// 未使用
	CloudRegion addCloudRegion(String cloudServiceId, CloudRegion cu) throws CloudManagerFault;
	CloudRegion modifyCloudRegion(String cloudServiceId, CloudRegion cu) throws CloudManagerFault;
	void removeCloudRegion(String cloudServiceId, String cloudRegionId) throws CloudManagerFault;

	CloudRegion findCloudRegion(String cloudServiceId, String region) throws CloudManagerFault;
	List<CloudRegion> findCloudRegionsByService(String cloudServiceId) throws CloudManagerFault;

	List<Zone> findZonesByRegion(String cloudServiceId, String region) throws CloudManagerFault;
}