package com.clustercontrol.cloud.factory;

import java.util.List;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.bean.CloudUser;
import com.clustercontrol.cloud.bean.CreateCloudUserRequest;
import com.clustercontrol.cloud.bean.ModifyCloudUserRequest;

public interface ICloudUserOperator {
	CloudUser createCloudAccount(CreateCloudUserRequest request) throws CloudManagerFault;
	CloudUser createCloudUser(CreateCloudUserRequest request) throws CloudManagerFault;
	CloudUser modifyCloudUser(ModifyCloudUserRequest request) throws CloudManagerFault;
	void removeCloudUser(String cloudUserId) throws CloudManagerFault;

	CloudUser findCloudUser(String cloudUserId) throws CloudManagerFault;
	CloudUser findCloudUserByRoleId(String roleId) throws CloudManagerFault;
	CloudUser findCloudUserByUserId(String hinemosUserId, String roleId) throws CloudManagerFault;

	List<CloudUser> findCloudUserByAccountResource(String accountResourceId) throws CloudManagerFault;
}