package com.clustercontrol.cloud.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.apache.log4j.Logger;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.Filter;
import com.clustercontrol.cloud.IResourceManagement.Storage;
import com.clustercontrol.cloud.bean.CloudStorage;
import com.clustercontrol.cloud.bean.CloudStorageBackup;
import com.clustercontrol.cloud.bean.CreateStorageBackupRequest;
import com.clustercontrol.cloud.bean.CreateStorageRequest;
import com.clustercontrol.cloud.bean.RestoreStorageRequest;
import com.clustercontrol.cloud.bean.Snapshot;
import com.clustercontrol.cloud.dao.CloudStorageDao;
import com.clustercontrol.cloud.util.HinemosUtil;
import com.clustercontrol.fault.InvalidRole;

public interface IStorageOperator extends IResourceOperatorBase {
	public class UpdateAllResult {
		public static class StorageMapping {
			public StorageMapping(Storage storage, CloudStorageDao cloudStorage) {
				this.storage = storage;
				this.cloudStorage = cloudStorage;
			}
			public Storage storage;
			public CloudStorageDao cloudStorage;
		}
		
		public final List<StorageMapping> both;
		public final List<StorageMapping> onlyAws;
		public final List<CloudStorageDao> onlyCloud;

		public UpdateAllResult(List<StorageMapping> both, List<StorageMapping> onlyAws, List<CloudStorageDao> onlyCloud) {
			this.both = Collections.unmodifiableList(both);
			this.onlyAws = Collections.unmodifiableList(onlyAws);
			this.onlyCloud = Collections.unmodifiableList(onlyCloud);
		}
		
		public List<CloudStorage> getCloudStorages() {
			Logger logger = Logger.getLogger(UpdateAllResult.class);

			List<CloudStorage> cloudStorages = new ArrayList<CloudStorage>();

			// AWS および Hinemos DB の両方に存在する。 
			for (StorageMapping mapping: both) {
				cloudStorages.add(new CloudStorage(mapping.cloudStorage, mapping.storage, HinemosUtil.getFacilityName(mapping.cloudStorage.getFacilityId())));
				logger.debug("Both : facilityId=" + mapping.cloudStorage.getFacilityId() + ", storageId=" + mapping.cloudStorage.getStorageId());
			}
			
			// AWS のみに存在する。 
			for (StorageMapping mapping: onlyAws) {
				cloudStorages.add(new CloudStorage(mapping.cloudStorage, mapping.storage, HinemosUtil.getFacilityName(mapping.cloudStorage.getFacilityId())));
				logger.debug("AWS : facilityId=" + mapping.cloudStorage.getFacilityId() + ", storageId=" + mapping.cloudStorage.getStorageId());
			}

			// Hinemos DB のみに存在する。 
			for (CloudStorageDao cs: onlyCloud) {
				cloudStorages.add(new CloudStorage(cs, HinemosUtil.getFacilityName(cs.getFacilityId())));
				logger.debug("Cloud : facilityId=" + cs.getFacilityId() + ", storageId=" + cs.getStorageId());
			}
			
			return cloudStorages;
		}
	}
	
	public class UpdateResult {
		public final String coudId;
		public final Storage stroage;
		public final CloudStorageDao cloudStorage;

		public UpdateResult( String coudId, Storage stroage, CloudStorageDao cloudStorage) {
			this.coudId = coudId;
			this.stroage = stroage;
			this.cloudStorage = cloudStorage;
		}
		
		public CloudStorage getCloudStorage() {
			if (cloudStorage != null) {
				if (stroage != null) {
					// クラウドインスタンスがないので、ダミーを作成し返す。
					return new CloudStorage(cloudStorage, stroage, HinemosUtil.getFacilityName(cloudStorage.getFacilityId()));
				}
				else {
					// クラウドインスタンスも EC2 インスタンスも存在しないので例外を返す。
					return new CloudStorage(cloudStorage, HinemosUtil.getFacilityName(cloudStorage.getFacilityId()));
				}
			}
			return null;
		}
	}
	
	void setFlags(boolean update, boolean regist, boolean relation);

	CloudStorage createStorage(CreateStorageRequest request) throws CloudManagerFault;
	CloudStorageBackup createStorageBackup(CreateStorageBackupRequest request) throws CloudManagerFault;
	CloudStorage restoreStorage(RestoreStorageRequest request) throws CloudManagerFault;
	void removeStorage(String storageId) throws CloudManagerFault, InvalidRole;
	void removeStorageBackup(String storageBackupId) throws CloudManagerFault;
	UpdateResult updateStorage(String storageId) throws CloudManagerFault, InvalidRole;		
	UpdateAllResult updateAllStorage() throws CloudManagerFault, InvalidRole;	
	void attachStorage(String instanceId, String storageId, String device) throws CloudManagerFault, InvalidRole;
	void detachStorage(String instanceId, String storageId) throws CloudManagerFault, InvalidRole;
	CloudStorage getStorage(String storageId) throws CloudManagerFault, InvalidRole;
	List<CloudStorage> getAllStorage() throws CloudManagerFault, InvalidRole;
	CloudStorageBackup getStorageBackup(String storageId) throws CloudManagerFault;
	List<CloudStorageBackup> getAllStorageBuckup() throws CloudManagerFault;
	List<CloudStorageBackup> getStorageBuckupsByStorageId(String storageId) throws CloudManagerFault;
	List<Snapshot> getSnapshotsWithFilter(List<Filter> filters) throws CloudManagerFault, InvalidRole;

	void updateAllStorageBackup() throws CloudManagerFault, InvalidRole;	

//	List<String> getFlavors() throws CloudManagerFault;
}
