package com.clustercontrol.cloud.factory;

import java.util.List;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.bean.CloudTemplate;
import com.clustercontrol.cloud.bean.CreateTemplateRequest;
import com.clustercontrol.cloud.bean.ModifyTemplateRequest;

public interface ITemplateOperator extends IResourceOperatorBase {

	CloudTemplate createTemplate(CreateTemplateRequest request) throws CloudManagerFault;
	
	CloudTemplate modifyTemplate(ModifyTemplateRequest request) throws CloudManagerFault;
	
	void removeTemplate(String templateId) throws CloudManagerFault;

	CloudTemplate findTemplate(String templateId) throws CloudManagerFault;

	List<CloudTemplate> findAllTemplates() throws CloudManagerFault;

	List<String> findTemplateScripts() throws CloudManagerFault;
}
