package com.clustercontrol.cloud.factory;

import java.util.ArrayList;
import java.util.List;

import javax.persistence.Query;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.ErrorCode;
import com.clustercontrol.cloud.IResourceManagement;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.dao.CloudResourceStoreDao;
import com.clustercontrol.cloud.persistence.EntityManagerEx;
import com.clustercontrol.cloud.persistence.Transactional;

@Transactional
public class ResourceStore implements IResourceManagement.IStore {
	private String accountResourceId;
	private String serviceId;
	private String region;

	public ResourceStore(String accountResourceId, String serviceId, String region) {
		super();
		this.accountResourceId = accountResourceId;
		this.serviceId = serviceId;
		this.region = region;
	}

	@Override
	public List<StoreValue> getValues(String resourceType) {
		EntityManagerEx em = SessionService.current().getEntityManagerEx();
		Query q = em.createQuery("select c from CloudResourceStoreDao c where c.accountResourceId = '" + accountResourceId + "' and region = '" + region + "' resourceType = " + resourceType);
		List<?> results = q.getResultList();

		List<StoreValue> values = new ArrayList<>();
		for (Object o: results) {
			CloudResourceStoreDao dao = (CloudResourceStoreDao)o;
			values.add(new StoreValue(resourceType, dao.getResourceId(), dao.getValue()));
		}
		return values;
	}

	@Override
	public String get(String resourceType, String resourceId) throws CloudManagerFault {
		EntityManagerEx em = SessionService.current().getEntityManagerEx();
		CloudResourceStoreDao dao = em.find(CloudResourceStoreDao.class, new CloudResourceStoreDao.CloudResourceStorePK(resourceId, resourceType, region, accountResourceId));
//		if (dao == null) {
//			throw ErrorCode.RESOURCESTORE_NOT_FOUND.cloudManagerFault(resourceId, resourceType, region, accountResourceId);
//		}
		return dao == null ? null: dao.getValue();
	}

	@Override
	public void put(String resourceType, String resourceId, String value) {
		EntityManagerEx em = SessionService.current().getEntityManagerEx();
		CloudResourceStoreDao dao = new CloudResourceStoreDao(resourceId, resourceType, serviceId, region, accountResourceId, value);
		em.persist(dao);
	}

	@Override
	public void remove(String resourceType, String resourceId) throws CloudManagerFault {
		EntityManagerEx em = SessionService.current().getEntityManagerEx();
		CloudResourceStoreDao dao = em.find(CloudResourceStoreDao.class, new CloudResourceStoreDao.CloudResourceStorePK(resourceId, resourceType, region, accountResourceId));
		if (dao == null) {
			throw ErrorCode.RESOURCESTORE_NOT_FOUND.cloudManagerFault(resourceId, resourceType, region, accountResourceId);
		}
		em.remove(dao);
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<String> getIds(String resourceType) throws CloudManagerFault {
		EntityManagerEx em = SessionService.current().getEntityManagerEx();
		Query q = em.createQuery("select c.resourceId from CloudResourceStoreDao c where c.accountResourceId = '" + accountResourceId + "' and region = '" + region + "' resourceType = " + resourceType);
		return (List<String>)q.getResultList();
	}
}
