package com.clustercontrol.cloud.factory;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import javax.persistence.EntityExistsException;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.ErrorCode;
import com.clustercontrol.cloud.Filter;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.bean.CloudTemplate;
import com.clustercontrol.cloud.bean.CreateTemplateRequest;
import com.clustercontrol.cloud.bean.ModifyTemplateRequest;
import com.clustercontrol.cloud.commons.CloudConstants;
import com.clustercontrol.cloud.commons.CloudPropertyConstants;
import com.clustercontrol.cloud.dao.CloudTemplateDao;
import com.clustercontrol.cloud.persistence.EntityManagerEx;
import com.clustercontrol.cloud.persistence.Transactional;

@Transactional
public class TemplateOperator extends ResourceOperatorBase implements ITemplateOperator, CloudConstants {

	@Override
	public CloudTemplate createTemplate(CreateTemplateRequest request) throws CloudManagerFault {
		EntityManagerEx em = SessionService.current().getEntityManagerEx();

		CloudTemplateDao dao = new CloudTemplateDao();
		dao.setTemplateId(request.getTemplateId());
		dao.setCloudServiceId(getCloudService().getCloudServiceId());
		dao.setRegion(request.getRegion());
		dao.setAccountResourceId(getAccountResource().getAccountResourceId());
		dao.setTemplateName(request.getTemplateName());
		dao.setCloudUserId(getCloudUser().getCloudUserId());
		dao.setJobUnitId(getAccountResource().getAccountResourceId());
		dao.setImageId(request.getImageId());
		dao.setStartJobId(request.getStartJobId());
		dao.setLaunchJobId(request.getLaunchJobId());
		dao.setStopJobId(request.getStopJobId());

		try {
			em.persist(dao);
		}
		catch (EntityExistsException e) {
			throw ErrorCode.CLOUDTEMPLATE_ALREADY_EXIST.cloudManagerFault(request.getTemplateId());
		}

		return new CloudTemplate(dao, getCloudService().getCloudTypeId());
	}

	@Override
	public CloudTemplate modifyTemplate(ModifyTemplateRequest request) throws CloudManagerFault {
		EntityManagerEx em = SessionService.current().getEntityManagerEx();
		CloudTemplateDao dao = em.find(CloudTemplateDao.class, request.getTemplateId());
		if (dao == null) {
			throw ErrorCode.CLOUDUSER_NOT_FOUND.cloudManagerFault(request.getTemplateId());
		}

		if (request.getTemplateName() != null) {
			dao.setTemplateName(request.getTemplateName());
		}
		if (request.getRegion() != null) {
			dao.setRegion(request.getRegion());
		}
		if (request.getImageId() != null) {
			dao.setImageId(request.getImageId());
		}
		if (request.getStartJobId() != null) {
			dao.setStartJobId(request.getStartJobId());
		}
		if (request.getLaunchJobId() != null) {
			dao.setLaunchJobId(request.getLaunchJobId());
		}
		if (request.getStopJobId() != null) {
			dao.setStopJobId(request.getStopJobId());
		}
		return new CloudTemplate(dao, getCloudService().getCloudTypeId());
	}

	@Override
	public void removeTemplate(String templateId) throws CloudManagerFault {
		EntityManagerEx em = SessionService.current().getEntityManagerEx();
		CloudTemplateDao dao = em.find(CloudTemplateDao.class, templateId);
		if (dao == null) {
			throw ErrorCode.CLOUDUSER_NOT_FOUND.cloudManagerFault(templateId);
		}
		em.remove(dao);
	}

	@Override
	public CloudTemplate findTemplate(String templateId) throws CloudManagerFault {
		EntityManagerEx em = SessionService.current().getEntityManagerEx();
		CloudTemplateDao dao = em.find(CloudTemplateDao.class, templateId);
		if (dao == null) {
			throw ErrorCode.CLOUDTEMPLATE_NOT_FOUND.cloudManagerFault(templateId);
		}
		return new CloudTemplate(dao, getCloudService().getCloudTypeId());
	}

	@Override
	public List<CloudTemplate> findAllTemplates() throws CloudManagerFault {
		EntityManagerEx em = SessionService.current().getEntityManagerEx();
		List<CloudTemplateDao> daos = em.findByFilter(CloudTemplateDao.class, new Filter("accountResourceId", getAccountResource().getAccountResourceId()));
		List<CloudTemplate> cloudTemplates = new ArrayList<>();
		for (CloudTemplateDao dao: daos) {
			cloudTemplates.add(new CloudTemplate(dao, getCloudService().getCloudTypeId()));
		}
		return cloudTemplates;
	}

	@Override
	public List<String> findTemplateScripts() throws CloudManagerFault {
		String hinemosHome = System.getProperty("hinemos.manager.home.dir");
		File directory = new File(hinemosHome + "/" + CloudPropertyConstants.templatejob_script_file_dir.value());
		File[] files = directory.listFiles();
		List<String> scripts = new ArrayList<>();
		for(File tmpFile: files){
			if (tmpFile.isFile()) {
				scripts.add(tmpFile.getName());
			}
		}
		return scripts;
	}
}
