package com.clustercontrol.cloud.factory.monitors;

import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

import com.clustercontrol.accesscontrol.session.AccessControllerBean;
import com.clustercontrol.cloud.HinemosCredential;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.commons.CloudPropertyConstants;
import com.clustercontrol.cloud.factory.ActionMode;
import com.clustercontrol.commons.util.HinemosSessionContext;

public abstract class AbstractCloudJob implements Job {

	@Override
	public void execute(JobExecutionContext context) throws JobExecutionException {
		try {
			String userId = CloudPropertyConstants.internal_thread_admin_user.value();
			HinemosSessionContext.instance().setProperty(HinemosSessionContext.LOGIN_USER_ID, userId);
			SessionService.current().setHinemosCredential(new HinemosCredential(userId));
			HinemosSessionContext.instance().setProperty(HinemosSessionContext.IS_ADMINISTRATOR, new AccessControllerBean().isAdministrator());

			internalExecute(context);
		}
		catch (JobExecutionException e) {
			throw e;
		}
		catch (Exception e) {
			throw new JobExecutionException(e);
		}
		finally {
			SessionService.current().close();
			ActionMode.leaveAutoDetection();
		}

	}

	protected abstract void internalExecute(JobExecutionContext context) throws Exception;
}
