package com.clustercontrol.cloud.util;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.IResourceManagement;
import com.clustercontrol.cloud.bean.CloudUser;

public class CloudCredential implements IResourceManagement.ICredential {
	private String accessKey;
	private String secretKey;

	public CloudCredential(String accessKey, String secretKey) {
		this.accessKey = accessKey;
		this.secretKey = secretKey;
	}

	public CloudCredential(CloudUser cloudUser) {
		this.accessKey = cloudUser.getAccessKey();
		this.secretKey = cloudUser.getSecretKey();
	}

	@Override
	public String getAccessKey() throws CloudManagerFault {
    	return accessKey;
	}

	@Override
	public String getSecretKey() throws CloudManagerFault {
    	return secretKey;
	}
}
