package com.clustercontrol.cloud.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;

import org.apache.log4j.Logger;

import com.clustercontrol.cloud.Messages;


public class CloudMessageUtil {
	public static final String pluginId = "CLOUD";
	public static final String InternalScopeText = "CLOUD";

	public static void notify_InvalidCronString(
		String monitorId,
		String application,
		String invalidCronString
		) {
		try {
			HinemosUtil.notifyInternalMessage(
					HinemosUtil.Priority.WARNING,
					pluginId,
					monitorId,
					"",
					InternalScopeText,
					application,
					Messages.getString("cloud.billingalarm.message.invalid_interval_string"),
					Messages.getString("cloud.billingalarm.message.invalid_interval_string.org", new Object[]{invalidCronString}));
		}
		catch (Exception e) {
			Logger.getLogger(CloudMessageUtil.class).warn(e.getMessage(), e);
		}
	}
	
	public static String getExceptionStackTrace(Exception exception) {
		ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
		PrintWriter writer = new PrintWriter(byteArray);
		exception.printStackTrace(writer);
		writer.flush();
		return byteArray.toString();
	}

	public static void notify_Not_Delete_AccountResource_Not_To_Delete_Facility(
		String accountResourceId,
		String facilityId,
		Exception exception
		) {
		HinemosUtil.notifyInternalMessage(
			HinemosUtil.Priority.WARNING,
			pluginId,
			accountResourceId,
			"",
			InternalScopeText,
			"AccountResourceOperator",
			Messages.getString("message.account_resource.not_delete_account_resource_not_to_delete_facility"),
			Messages.getString("message.account_resource.not_delete_account_resource_not_to_delete_facility.org", new Object[]{accountResourceId, facilityId}) + "\n" + getExceptionStackTrace(exception));
	}

	public static void notify_Not_Delete_AccountResource_Not_To_Delete_JobUnit(
		String accountResourceId,
		String jobUnitId,
		Exception exception
		) {
		HinemosUtil.notifyInternalMessage(
			HinemosUtil.Priority.WARNING,
			pluginId,
			accountResourceId,
			"",
			InternalScopeText,
			"AccountResourceOperator",
			Messages.getString("message.account_resource.not_delete_account_resource_not_to_delete_jobunit"),
			Messages.getString("message.account_resource.not_delete_account_resource_not_to_delete_jobunit.org", new Object[]{accountResourceId, jobUnitId}) + "\n" + getExceptionStackTrace(exception));
	}

	public static void notify_AutoUpadate_Error_InstanceOperator(
			String accountResourceId,
			String instanceId,
			Exception exception
			) {
		HinemosUtil.notifyInternalMessage(
			HinemosUtil.Priority.WARNING,
			pluginId,
			accountResourceId,
			Messages.getString("message.autoupdate.error.detail1", new Object[]{accountResourceId, instanceId}),
			InternalScopeText,
			"InstanceOperator",
			Messages.getString("message.autoupdate.error"),
			getExceptionStackTrace(exception));
	}

	public static void notify_AutoUpadate_Error_StorageOperator(
			String accountResourceId,
			String storageId,
			Exception exception
			) {
		HinemosUtil.notifyInternalMessage(
			HinemosUtil.Priority.WARNING,
			pluginId,
			accountResourceId,
			Messages.getString("message.autoupdate.error.detail2", new Object[]{accountResourceId, storageId}),
			InternalScopeText,
			"StorageOperator",
			Messages.getString("message.autoupdate.error"),
			getExceptionStackTrace(exception));
	}
}