package com.clustercontrol.cloud.util;

import com.clustercontrol.cloud.IResourceManagement;
import com.clustercontrol.cloud.InternalManagerError;
import com.clustercontrol.cloud.IResourceManagement.IEndpoint;
import com.clustercontrol.cloud.bean.CloudRegion;

public class ResourceRegion implements IResourceManagement.IRegion {
	private CloudRegion cloudRegion;

	public ResourceRegion(CloudRegion cloudRegion) {
		this.cloudRegion = cloudRegion;
	}
	
	@Override
	public String getName() {
		return cloudRegion.getRegion();
	}

	@Override
	public IEndpoint getEndpoint(final String type) {
		final String location = cloudRegion.getEndpoint(type).getLocation();
		if (location != null) {
			return new IEndpoint() {
				@Override
				public String getEndpointType() {
					return type;
				}
				@Override
				public String getLocation() {
					return location;
				}
			};
		}
		else {
			throw new InternalManagerError();
		}
	}
}
