package com.clustercontrol.cloud.validation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import javax.persistence.NoResultException;
import javax.persistence.Query;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.ErrorCode;
import com.clustercontrol.cloud.IMessagesHolder;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.persistence.EntityManagerEx;
import com.clustercontrol.cloud.validation.ValidationUtil.AbstractValidator;
import com.clustercontrol.cloud.validation.annotation.ValidatedBy;

@Retention(RetentionPolicy.RUNTIME)  
@Target({ElementType.METHOD, ElementType.PARAMETER})
@ValidatedBy(com.clustercontrol.cloud.validation.AccessibleAccountResource.Validator.class)
public @interface AccessibleAccountResource {
	public class Validator extends AbstractValidator<AccessibleAccountResource, String> {
		@Override
		public void init(AccessibleAccountResource annotation) {
			setElementId(annotation.elementId());
			setValidationId(annotation.validationId());
			setGroups(annotation.groups());
		}

		@Override
		protected void internalValidate(String property, String group, IMessagesHolder messages) throws ValidationFault {
			if (property == null || property.isEmpty()) {
				return;
			}

			EntityManagerEx em = SessionService.current().getEntityManagerEx();
			Query query = em.createQuery("SELECT DISTINCT u.accountResource FROM CloudUserDao u, UserEntity h, RoleEntity r WHERE u.accountResource.accountResourceId = :accountResourceId AND h.userId = :userId AND h MEMBER OF r.userEntities AND r.roleId = u.roleId");
			query.setParameter("accountResourceId", property);
			query.setParameter("userId", SessionService.current().getHinemosCredential().getUserId());
			
			try {
				query.getSingleResult();
			}
			catch (NoResultException e) {
				CloudManagerFault f = ErrorCode.ACCOUNTRESOURCE_INVALID_ACCOUNTRESOURCE_NOT_FOUND.cloudManagerFault(property);
				throw new ValidationFault(f.getMessage(), f.getErrorCode(), f);
			}
		}
	}
	
	String elementId() default "";
	String validationId() default "com.clustercontrol.cloud.validation.AccountResourceAccessibleValidator";
	String[] groups() default {};
}