package com.clustercontrol.cloud.validation;

import java.lang.reflect.Method;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.ErrorCode;
import com.clustercontrol.cloud.IMessagesHolder;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.validation.MethodValidator.MethodValidationContext;
import com.clustercontrol.commons.util.HinemosSessionContext;

public class AuthorizingValidator_is_administrator implements CustomMethodValidator {
	@Override
	public void validate(Method method, Object[] params, String group, IMessagesHolder messages, MethodValidationContext context) throws ValidationFault {
		try {
			if (
				!Boolean.TRUE.equals(HinemosSessionContext.instance().getProperty(HinemosSessionContext.IS_ADMINISTRATOR))
				) {
				throw ErrorCode.NEED_ADMINISTRATORS_ROLE.cloudManagerFault(SessionService.current().getHinemosCredential().getUserId());
			}
		}
		catch (CloudManagerFault e) {
			throw new ValidationFault(e);
		}
	}
}