package com.clustercontrol.cloud.validation;

import java.lang.reflect.Method;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.ErrorCode;
import com.clustercontrol.cloud.IMessagesHolder;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.bean.CloudUser;
import com.clustercontrol.cloud.dao.CloudUserDao.CloudUserType;
import com.clustercontrol.cloud.factory.ICloudUserOperator;
import com.clustercontrol.cloud.registry.ObjectRegistryService;
import com.clustercontrol.cloud.util.AuthorizingUtil;
import com.clustercontrol.cloud.validation.MethodValidator.MethodValidationContext;

public class AuthorizingValidator_remove_clouduser implements CustomMethodValidator {
	@Override
	public void validate(Method method, Object[] params, String group, IMessagesHolder messages, MethodValidationContext context) throws ValidationFault {
		try {
			CloudUser cu = ObjectRegistryService.registry().get(ICloudUserOperator.class).findCloudUser((String)params[0]);
			if (cu.getCloudUserType() == CloudUserType.account) {
				throw ErrorCode.CLOUDUSER_CAN_NOT_REMOVE_ACCOUNT.cloudManagerFault((String)params[0]);
			}
			
			if (!AuthorizingUtil.checkHinemousUser_administrators_account(SessionService.current().getHinemosCredential().getUserId(), cu.getAccountResourceId())) {
				throw ErrorCode.NEED_ADMINISTRATORS_ROLE_OR_ACCOUT_USER.cloudManagerFaultByIndex(1, SessionService.current().getHinemosCredential().getUserId(), (String)params[0]);
			}
		}
		catch (CloudManagerFault e) {
			throw new ValidationFault(e);
		}
	}
}