package com.clustercontrol.cloud.validation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import javax.persistence.NoResultException;
import javax.persistence.Query;

import com.clustercontrol.accesscontrol.bean.RoleIdConstant;
import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.ErrorCode;
import com.clustercontrol.cloud.IMessagesHolder;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.persistence.EntityManagerEx;
import com.clustercontrol.cloud.validation.ValidationUtil.AbstractValidator;
import com.clustercontrol.cloud.validation.annotation.ValidatedBy;

@Retention(RetentionPolicy.RUNTIME)  
@Target({ElementType.METHOD, ElementType.PARAMETER})
@ValidatedBy(com.clustercontrol.cloud.validation.ModifiableAccountResource.Validator.class)
public @interface ModifiableAccountResource {
	public class Validator extends AbstractValidator<ModifiableAccountResource, String> {
		@Override
		public void init(ModifiableAccountResource annotation) {
			setElementId(annotation.elementId());
			setValidationId(annotation.validationId());
			setGroups(annotation.groups());
		}

		@Override
		protected void internalValidate(String property, String group, IMessagesHolder messages) throws ValidationFault {
			if (property == null || property.isEmpty()) {
				return;
			}

			// アカウントリソースへの変更が可能かどうか確認。
			// アカウントリソースの管理者のみ変更可。
			// 実行中のアカウントが、アカウントリソースの管理者アカウントに紐づくロールを持っているか確認。
			EntityManagerEx em = SessionService.current().getEntityManagerEx();
			Query query1 = em.createQuery("SELECT DISTINCT u.accountResource FROM CloudUserDao u, UserEntity h, RoleEntity r WHERE u.accountResource.accountResourceId = :accountResourceId AND h.userId = :userId AND h MEMBER OF r.userEntities AND r.roleId = u.roleId");
			query1.setParameter("accountResourceId", property);
			query1.setParameter("userId", SessionService.current().getHinemosCredential().getUserId());
			
			try {
				query1.getSingleResult();
			}
			catch (NoResultException e1) {
				Query query2 = em.createQuery("SELECT DISTINCT h FROM UserEntity h, RoleEntity r WHERE h.userId = :userId AND h MEMBER OF r.userEntities AND r.roleId = :ADMINISTRATORS");
				query2.setParameter("userId", SessionService.current().getHinemosCredential().getUserId());
				query2.setParameter("ADMINISTRATORS", RoleIdConstant.ADMINISTRATORS);
				
				try {
					query2.getSingleResult();
				}
				catch (NoResultException e2) {
					CloudManagerFault f = ErrorCode.ACCOUNTRESOURCE_INVALID_ACCOUNTRESOURCE_NOT_FOUND.cloudManagerFault(property);
					throw new ValidationFault(f.getMessage(), f.getErrorCode(), f);
				}
			}
		}
	}
	
	String elementId() default "";
	String validationId() default "com.clustercontrol.cloud.validation.AccountResourceAccessibleValidator";
	String[] groups() default {};
}