/*
TTデータの澤井TTデータの澤井Copyright (C) 2013 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
*/
package com.clustercontrol.ws.cloud;

import static com.clustercontrol.cloud.util.ResourceUtil.getResourceOperator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import javax.annotation.Resource;
import javax.jws.WebService;
import javax.persistence.Query;
import javax.xml.ws.WebServiceContext;

import com.clustercontrol.accesscontrol.bean.FunctionConstant;
import com.clustercontrol.accesscontrol.bean.RoleIdConstant;
import com.clustercontrol.accesscontrol.bean.PrivilegeConstant.SystemPrivilegeMode;
import com.clustercontrol.accesscontrol.model.RoleEntity;
import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.ErrorCode;
import com.clustercontrol.cloud.Filter;
import com.clustercontrol.cloud.ICloudContext;
import com.clustercontrol.cloud.IResourceManagement;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.bean.AvailableRole;
import com.clustercontrol.cloud.bean.CloudAccountResource;
import com.clustercontrol.cloud.bean.CloudInstance;
import com.clustercontrol.cloud.bean.CloudInstanceBackup;
import com.clustercontrol.cloud.bean.CloudRegion;
import com.clustercontrol.cloud.bean.CloudService;
import com.clustercontrol.cloud.bean.CloudStorage;
import com.clustercontrol.cloud.bean.CloudStorageBackup;
import com.clustercontrol.cloud.bean.CloudTemplate;
import com.clustercontrol.cloud.bean.CloudType;
import com.clustercontrol.cloud.bean.CloudUser;
import com.clustercontrol.cloud.bean.CreateAccountResourceRequest;
import com.clustercontrol.cloud.bean.CreateCloudUserRequest;
import com.clustercontrol.cloud.bean.CreateInstanceBackupRequest;
import com.clustercontrol.cloud.bean.CreateInstanceByTemplateRequest;
import com.clustercontrol.cloud.bean.CreateInstanceRequest;
import com.clustercontrol.cloud.bean.CreateStorageBackupRequest;
import com.clustercontrol.cloud.bean.CreateStorageRequest;
import com.clustercontrol.cloud.bean.CreateTemplateRequest;
import com.clustercontrol.cloud.bean.Image;
import com.clustercontrol.cloud.bean.InstanceStateChange;
import com.clustercontrol.cloud.bean.ModifyAccountBillingDetailRequest;
import com.clustercontrol.cloud.bean.ModifyAccountResourceRequest;
import com.clustercontrol.cloud.bean.ModifyCloudUserRequest;
import com.clustercontrol.cloud.bean.ModifyTemplateRequest;
import com.clustercontrol.cloud.bean.RegistNodeRequest;
import com.clustercontrol.cloud.bean.RestoreInstanceRequest;
import com.clustercontrol.cloud.bean.RestoreStorageRequest;
import com.clustercontrol.cloud.bean.Snapshot;
import com.clustercontrol.cloud.bean.StartInstanceRequest;
import com.clustercontrol.cloud.bean.StopInstanceRequest;
import com.clustercontrol.cloud.bean.Zone;
import com.clustercontrol.cloud.factory.CloudRoleConstants;
import com.clustercontrol.cloud.factory.IAccountResourceOperator;
import com.clustercontrol.cloud.factory.ICloudServiceOperator;
import com.clustercontrol.cloud.factory.ICloudUserOperator;
import com.clustercontrol.cloud.factory.IInstanceOperator;
import com.clustercontrol.cloud.factory.IStorageOperator;
import com.clustercontrol.cloud.factory.ITemplateOperator;
import com.clustercontrol.cloud.factory.InstanceOperator;
import com.clustercontrol.cloud.persistence.EntityManagerEx;
import com.clustercontrol.cloud.registry.ObjectRegistryService;
import com.clustercontrol.cloud.validation.AuthorizingValidator_remove_clouduser;
import com.clustercontrol.cloud.validation.AuthorizingValidator_is_administrator;
import com.clustercontrol.cloud.validation.AuthorizingValidator_role;
import com.clustercontrol.cloud.validation.AuthorizingValidator_role_region;
import com.clustercontrol.cloud.validation.ModifiableAccountResource;
import com.clustercontrol.cloud.validation.annotation.CustomMethodValidation;
import com.clustercontrol.cloud.validation.annotation.ElementId;
import com.clustercontrol.cloud.validation.annotation.Identity;
import com.clustercontrol.cloud.validation.annotation.Into;
import com.clustercontrol.cloud.validation.annotation.NotNull;
import com.clustercontrol.cloud.validation.annotation.NotNullContainer;
import com.clustercontrol.cloud.validation.annotation.Size;
import com.clustercontrol.cloud.validation.annotation.ValidationGroup;
import com.clustercontrol.commons.util.HinemosSessionContext;
import com.clustercontrol.fault.FacilityNotFound;
import com.clustercontrol.fault.InvalidRole;
import com.clustercontrol.fault.InvalidSetting;
import com.clustercontrol.fault.InvalidUserPass;
import com.clustercontrol.repository.util.FacilityTreeCache;
import com.clustercontrol.ws.cloud.security.HinemosAccessRight;
import com.clustercontrol.ws.cloud.security.HinemosAccessRights;

/**
 * クラウド管理オプション用のエンドポイント
 *
 */
@WebService(serviceName = "CloudEndpointService", portName = "CloudEndpointPort", targetNamespace = "http://cloud.ws.clustercontrol.com", endpointInterface="com.clustercontrol.ws.cloud.CloudEndpoint")
public class CloudEndpointImpl implements CloudEndpoint, IWebServiceBase, CloudRoleConstants {
	@Resource
	private WebServiceContext wsctx;
	
	@Override
	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.EXEC)
	@CustomMethodValidation(AuthorizingValidator_role_region.class)
	@ValidationGroup("addInstance")
	public CloudInstance addInstance(
			@ElementId("roleId") @Identity String roleId,
			@ElementId("region") @NotNull @Size(max=64) String region, 
			@ElementId("CreateInstanceRequest") @NotNull @Into CreateInstanceRequest request
			) throws InvalidUserPass, InvalidRole, CloudManagerFault {
		return getResourceOperator(IInstanceOperator.class).createInstance(request);
	}

	@Override
	@HinemosAccessRights({
		@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.EXEC),
		@HinemosAccessRight(roleName=FunctionConstant.JOBMANAGEMENT, right={SystemPrivilegeMode.READ, SystemPrivilegeMode.WRITE, SystemPrivilegeMode.EXEC}),
		})
	@CustomMethodValidation(AuthorizingValidator_role_region.class)
	@ValidationGroup("addInstanceByTemplate")
	public CloudInstance addInstanceByTemplate(
			@ElementId("roleId") @Identity String roleId,
			@ElementId("region") @NotNull @Size(max=64) String region, 
			@ElementId("CreateInstanceByTemplateRequest") @NotNull @Into CreateInstanceByTemplateRequest request
			) throws InvalidUserPass, InvalidRole, CloudManagerFault {
		return getResourceOperator(IInstanceOperator.class).createInstanceByTemplate(request);
	}
	
	@Override
	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.EXEC)
	@CustomMethodValidation(AuthorizingValidator_role_region.class)
	@ValidationGroup("restoreInstance")
	public CloudInstance restoreInstance(
			@ElementId("roleId") @Identity String roleId,
			@ElementId("region") @NotNull @Size(max=64) String region, 
			@ElementId("RestoreInstanceRequest") @NotNull @Into RestoreInstanceRequest request
			) throws CloudManagerFault, InvalidUserPass, InvalidRole {
		return getResourceOperator(IInstanceOperator.class).restoreInstance(request);
	}

	@Override
	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.EXEC)
	@CustomMethodValidation(AuthorizingValidator_role_region.class)
	public void removeInstance(
			@ElementId("roleId") @Identity String roleId,
			@ElementId("region") @NotNull @Size(max=64) String region, 
			@ElementId("instanceId") @NotNull @Size(max=64) String instanceId
			) throws InvalidUserPass, InvalidRole, CloudManagerFault {
		getResourceOperator(IInstanceOperator.class).removeInstance(instanceId);
	}

	@Override
	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.READ)
	@CustomMethodValidation(AuthorizingValidator_role_region.class)
	public CloudInstance getInstance(
			@ElementId("roleId") @Identity String roleId,
			@ElementId("region") @NotNull @Size(max=64) String region,
			@ElementId("instanceId") @NotNull @Size(max=64) String instanceId
			) throws CloudManagerFault, InvalidUserPass, InvalidRole {
		return getResourceOperator(IInstanceOperator.class).getInstance(instanceId);
	}

	@Override
	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.READ)
	@CustomMethodValidation(AuthorizingValidator_role_region.class)
	public List<CloudInstance> getInstancesByRegion(
			@ElementId("roleId") @Identity String roleId,
			@ElementId("region") @NotNull @Size(max=64) String region
			) throws CloudManagerFault, InvalidUserPass, InvalidRole {
		return getResourceOperator(IInstanceOperator.class).getAllInstances();
	}

	@Override
	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.EXEC)
	@CustomMethodValidation(AuthorizingValidator_role_region.class)
	public InstanceStateChange startInstance(
			@ElementId("roleId") @Identity String roleId,
			@ElementId("region") @NotNull @Size(max=64) String region,
			@ElementId("StartInstanceRequest") @NotNull StartInstanceRequest request
			) throws CloudManagerFault, InvalidUserPass, InvalidRole {
		return getResourceOperator(IInstanceOperator.class).startInstance(request);
	}
	
	@Override
	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.EXEC)
	@CustomMethodValidation(AuthorizingValidator_role_region.class)
	public InstanceStateChange stopInstance(
			@ElementId("roleId") @Identity String roleId,
			@ElementId("region") @NotNull @Size(max=64) String region,
			@ElementId("StopInstanceRequest") @NotNull StopInstanceRequest request
			) throws CloudManagerFault, InvalidUserPass, InvalidRole {
		return getResourceOperator(IInstanceOperator.class).stopInstance(request);
	}

	@Override
	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.WRITE)
	public CloudUser addCloudUser(
			@ElementId("CreateCloudUserRequest") @NotNull @Into CreateCloudUserRequest request
			) throws CloudManagerFault, InvalidUserPass, InvalidRole {
		return ObjectRegistryService.registry().get(ICloudUserOperator.class).createCloudUser(request);
	}
	
	@Override
	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.READ)
	public List<CloudUser> getCloudUsersByAccountResource(
			@ElementId("accountResourceId") @Identity String accountResourceId
			) throws CloudManagerFault, InvalidUserPass, InvalidRole {
		return ObjectRegistryService.registry().get(ICloudUserOperator.class).findCloudUserByAccountResource(accountResourceId);
	}
	
	@Override
	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.READ)
	public CloudUser getCloudUser(
			@ElementId("cloudUserId") @Identity String cloudUserId
			) throws CloudManagerFault, InvalidUserPass, InvalidRole {
		return ObjectRegistryService.registry().get(ICloudUserOperator.class).findCloudUser(cloudUserId);
	}
	
	@Override
	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.WRITE)
	@CustomMethodValidation(AuthorizingValidator_remove_clouduser.class)
	public void removeCloudUser(
			@ElementId("cloudUserId") @Identity String cloudUserId
			) throws CloudManagerFault, InvalidUserPass, InvalidRole {
		ObjectRegistryService.registry().get(ICloudUserOperator.class).removeCloudUser(cloudUserId);
	}
	
	@Override
	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.WRITE)
	public CloudUser modifyCloudUser(@ElementId("ModifyCloudUserRequest") @NotNull @Into ModifyCloudUserRequest request) throws CloudManagerFault, InvalidUserPass, InvalidRole {
		return ObjectRegistryService.registry().get(ICloudUserOperator.class).modifyCloudUser(request);
	}
	
	@Override
	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.READ)
	public List<CloudType> getAllSupportedCloudTypes() throws CloudManagerFault, InvalidUserPass, InvalidRole {
		return Collections.emptyList();
	}

	@Override
	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.READ)
	public List<CloudRegion> getRegionsByService(@ElementId("cloudServiceId") @Identity String cloudServiceId) throws CloudManagerFault, InvalidUserPass, InvalidRole {
		return ObjectRegistryService.registry().get(ICloudServiceOperator.class).findCloudRegionsByService(cloudServiceId);
	}

	@Override
	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.READ)
	@CustomMethodValidation(AuthorizingValidator_role.class)
	public List<Zone> getZones(
			@ElementId("roleId") @Identity String roleId,
			@ElementId("region") @NotNull @Size(max=64) String region
			) throws CloudManagerFault, InvalidUserPass, InvalidRole {
		ICloudContext context = SessionService.current().get(ICloudContext.class);
		return ObjectRegistryService.registry().get(ICloudServiceOperator.class).findZonesByRegion(context.getAccessDestionation().getCloudService().getCloudServiceId(), region);
	}

	@Override
	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.READ)
	@CustomMethodValidation(AuthorizingValidator_role_region.class)
	public List<Image> getImagesWithFilter(
			@ElementId("roleId") @Identity String roleId,
			@ElementId("region") @NotNull @Size(max=64) String region,
			@ElementId("filters") @NotNull @NotNullContainer @Into List<Filter> filters
			) throws CloudManagerFault, InvalidUserPass, InvalidRole {
		return getResourceOperator(IInstanceOperator.class).getImagesWithFilter(filters);
	}

	@Override
	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.READ)
	public List<String> getInstanceFlavorsByService(@ElementId("cloudServiceId") @Identity String cloudServiceId) throws CloudManagerFault, InvalidUserPass, InvalidRole {
		ICloudServiceOperator operator = ObjectRegistryService.registry().get(ICloudServiceOperator.class);
		CloudService service = operator.findCloudService(cloudServiceId);
		IResourceManagement rm = ObjectRegistryService.registry().get(IResourceManagement.class, service.getCloudTypeId());
		if (rm == null) {
			throw ErrorCode.RESOURCEMANAGEMENT_NOT_FOUND.cloudManagerFault(service.getCloudTypeId());
		}
		return rm.getInstanceFlavors();
	}
	
	@Override
	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.READ)
	@CustomMethodValidation(AuthorizingValidator_role_region.class)
	public List<Snapshot> getSnapshotsWithFilter(
			@ElementId("roleId") @Identity String roleId,
			@ElementId("region") @NotNull @Size(max=64) String region,
			@ElementId("filters") @NotNull @NotNullContainer @Into List<Filter> filters
			) throws CloudManagerFault, InvalidUserPass, InvalidRole {
		return getResourceOperator(IStorageOperator.class).getSnapshotsWithFilter(filters);
	}

	@Override
	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.EXEC)
	@CustomMethodValidation(AuthorizingValidator_role_region.class)
	public void attachStorage(
			@ElementId("roleId") @Identity String roleId,
			@ElementId("region") @NotNull @Size(max=64) String region,
			@ElementId("instanceId") @NotNull @Size(max=64) String instanceId,
			@ElementId("storageId") @NotNull @Size(max=64) String storageId,
			@ElementId("deviceName") @NotNull @Size(max=128) String deviceName
			) throws CloudManagerFault, InvalidUserPass, InvalidRole  {
		getResourceOperator(IStorageOperator.class).attachStorage(instanceId, storageId, deviceName);
	}

	@Override
	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.EXEC)
	@CustomMethodValidation(AuthorizingValidator_role_region.class)
	public void detachStorage(
			@ElementId("roleId") @Identity String roleId,
			@ElementId("region") @NotNull @Size(max=64) String region,
			@ElementId("instanceId") @NotNull @Size(max=64) String instanceId,
			@ElementId("storageId") @NotNull @Size(max=64) String storageId
			) throws CloudManagerFault, InvalidUserPass, InvalidRole {
		getResourceOperator(IStorageOperator.class).detachStorage(instanceId, storageId);
	}
	
	@Override
	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.EXEC)
	@CustomMethodValidation(AuthorizingValidator_role_region.class)
	public CloudStorage addStorage(
			@ElementId("roleId") @Identity String roleId,
			@ElementId("region") @NotNull @Size(max=64) String region,
			@ElementId("CreateStorageRequest") @NotNull @Into CreateStorageRequest request
			) throws CloudManagerFault, InvalidUserPass, InvalidRole {
		return getResourceOperator(IStorageOperator.class).createStorage(request);
	}

	@Override
	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.EXEC)
	@CustomMethodValidation(AuthorizingValidator_role_region.class)
	public CloudStorage restoreStorage(
			@ElementId("roleId") @Identity String roleId,
			@ElementId("region") @NotNull @Size(max=64) String region,
			@ElementId("RestoreStorageRequest") @NotNull @Into RestoreStorageRequest request
			) throws CloudManagerFault, InvalidUserPass, InvalidRole {
		return getResourceOperator(IStorageOperator.class).restoreStorage(request);
	}
	
	@Override
	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.EXEC)
	@CustomMethodValidation(AuthorizingValidator_role_region.class)
	public void removeStorage(
			@ElementId("roleId") @Identity String roleId,
			@ElementId("region") @NotNull @Size(max=64) String region,
			@ElementId("storageId") @NotNull @Size(max=64) String storageId
			) throws CloudManagerFault, InvalidUserPass, InvalidRole {
		getResourceOperator(IStorageOperator.class).removeStorage(storageId);
	}

	@Override
	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.READ)
	@CustomMethodValidation(AuthorizingValidator_role_region.class)
	public CloudStorage getStorage(
			@ElementId("roleId") @Identity String roleId,
			@ElementId("region") @NotNull @Size(max=64) String region,
			@ElementId("storageId") @NotNull @Size(max=64) String storageId
			) throws CloudManagerFault, InvalidUserPass, InvalidRole {
		return getResourceOperator(IStorageOperator.class).getStorage(storageId);
	}

	@Override
	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.READ)
	@CustomMethodValidation(AuthorizingValidator_role_region.class)
	public List<CloudStorage> getStoragesByRegion(
			@ElementId("roleId") @Identity String roleId,
			@ElementId("region") @NotNull @Size(max=64) String region
			) throws CloudManagerFault, InvalidUserPass, InvalidRole {
		return getResourceOperator(IStorageOperator.class).getAllStorage();
	}
	
	@Override
	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.EXEC)
	@CustomMethodValidation(AuthorizingValidator_role_region.class)
	public CloudStorageBackup addStorageBackup(
			@ElementId("roleId") @Identity String roleId,
			@ElementId("region") @NotNull @Size(max=64) String region,
			@ElementId("CreateStorageBackupRequest") @NotNull @Into CreateStorageBackupRequest request
			) throws CloudManagerFault, InvalidUserPass, InvalidRole {
		return getResourceOperator(IStorageOperator.class).createStorageBackup(request);
	}

	@Override
	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.EXEC)
	@CustomMethodValidation(AuthorizingValidator_role_region.class)
	public void removeStorageBackup(
			@ElementId("roleId") @Identity String roleId,
			@ElementId("region") @NotNull @Size(max=64) String region,
			@ElementId("storageBackupId") @NotNull @Size(max=64) String storageBackupId
			) throws CloudManagerFault, InvalidUserPass, InvalidRole {
		getResourceOperator(IStorageOperator.class).removeStorageBackup(storageBackupId);
	}

	@Override
	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.READ)
	@CustomMethodValidation(AuthorizingValidator_role_region.class)
	public CloudStorageBackup getStorageBackup(
			@ElementId("roleId") @Identity String roleId,
			@ElementId("region") @NotNull @Size(max=64) String region,
			@ElementId("storageBackupId") @NotNull @Size(max=64) String storageBackupId
			) throws CloudManagerFault, InvalidUserPass, InvalidRole {
		return getResourceOperator(IStorageOperator.class).getStorageBackup(storageBackupId);
	}

	@Override
	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.READ)
	@CustomMethodValidation(AuthorizingValidator_role_region.class)
	public List<CloudStorageBackup> getStorageBackupsByRegion(
			@ElementId("roleId") @Identity String roleId,
			@ElementId("region") @NotNull @Size(max=64) String region
			) throws CloudManagerFault, InvalidUserPass, InvalidRole {
		return getResourceOperator(IStorageOperator.class).getAllStorageBuckup();
	}

	@Override
	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.EXEC)
	@CustomMethodValidation(AuthorizingValidator_role_region.class)
	public CloudInstanceBackup addInstanceBackup(
			@ElementId("roleId") @Identity String roleId,
			@ElementId("region") @NotNull @Size(max=64) String region,
			@ElementId("CreateInstanceBackupRequest") @NotNull @Into CreateInstanceBackupRequest request
			) throws CloudManagerFault, InvalidUserPass, InvalidRole {
		return getResourceOperator(IInstanceOperator.class).createInstanceBackup(request);
	}

	@Override
	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.EXEC)
	@CustomMethodValidation(AuthorizingValidator_role_region.class)
	public void removeInstanceBackup(
			@ElementId("roleId") @Identity String roleId,
			@ElementId("region") @NotNull @Size(max=64) String region,
			@ElementId("instanceBackupId") @NotNull @Size(max=64) String instanceBackupId
			) throws CloudManagerFault, InvalidUserPass, InvalidRole {
		getResourceOperator(IInstanceOperator.class).removeInstanceBackup(instanceBackupId);
	}

	@Override
	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.EXEC)
	@CustomMethodValidation(AuthorizingValidator_role_region.class)
	public CloudInstanceBackup getInstanceBackup(
			@ElementId("roleId") @Identity String roleId,
			@ElementId("region") @NotNull @Size(max=64) String region,
			@ElementId("instanceBackupId") @NotNull @Size(max=64) String instanceBackupId
			) throws CloudManagerFault, InvalidUserPass, InvalidRole {
		return getResourceOperator(IInstanceOperator.class).getInstanceBackup(instanceBackupId);
	}

	@Override
	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.EXEC)
	@CustomMethodValidation(AuthorizingValidator_role_region.class)
	public List<CloudInstanceBackup> getInstanceBackupsByRegion(
			@ElementId("roleId") @Identity String roleId,
			@ElementId("region") @NotNull @Size(max=64) String region
			) throws CloudManagerFault, InvalidUserPass, InvalidRole {
		return getResourceOperator(IInstanceOperator.class).getAllInstanceBackup();
	}

	@Override
	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.EXEC)
	@CustomMethodValidation(AuthorizingValidator_role_region.class)
	@ValidationGroup("registNode")
	public CloudInstance registNode(
			@ElementId("roleId") @Identity String roleId,
			@ElementId("region") @NotNull @Size(max=64) String region,
			@ElementId("RegistNodeRequest") @NotNull @Into RegistNodeRequest request
			) throws InvalidUserPass, InvalidRole, CloudManagerFault {
		return getResourceOperator(IInstanceOperator.class).registNode(request);
	}

	@Override
	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.EXEC)
	@CustomMethodValidation(AuthorizingValidator_role_region.class)
	public void unregistNode(
			@ElementId("roleId") @Identity String roleId,
			@ElementId("region") @NotNull @Size(max=64) String region,
			@ElementId("instanceId") @NotNull @Size(max=64) String instanceId
			) throws InvalidUserPass, InvalidRole, CloudManagerFault {
		getResourceOperator(IInstanceOperator.class).unregistNode(instanceId);
	}
	
//	@Override
//	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.READ)
//	@CustomMethodValidation(AuthorizingValidator.class)getResourceOperator
//	public List<String> getAllServiceName() throws InvalidUserPass, InvalidRole, CloudManagerFault {
//		return Arrays.asList(createCloudCommandFacade().getAllServiceName());
//	}

	@Override
	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.WRITE)
	@CustomMethodValidation(AuthorizingValidator_role.class)
	public CloudTemplate addTemplate(
			@ElementId("roleId") @Identity String roleId,
			@ElementId("CreateTemplateRequest") @NotNull @Into CreateTemplateRequest request
			) throws CloudManagerFault, InvalidUserPass, InvalidRole {
		return getResourceOperator(ITemplateOperator.class).createTemplate(request);
	}

	@Override
	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.WRITE)
	@CustomMethodValidation(AuthorizingValidator_role.class)
	public void removeTemplate(
			@ElementId("roleId") @Identity String roleId,
			@ElementId("templateId") @Identity String templateId
			) throws CloudManagerFault, InvalidUserPass, InvalidRole {
		getResourceOperator(ITemplateOperator.class).removeTemplate(templateId);
	}

	@Override
	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.WRITE)
	@CustomMethodValidation(AuthorizingValidator_role.class)
	public CloudTemplate modifyTemplate(
			@ElementId("roleId") @Identity String roleId,
			@ElementId("ModifyTemplateRequest") @NotNull @Into ModifyTemplateRequest request
			) throws CloudManagerFault, InvalidUserPass, InvalidRole {
		return getResourceOperator(ITemplateOperator.class).modifyTemplate(request);
	}

	@Override
	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.READ)
	@CustomMethodValidation(AuthorizingValidator_role.class)
	public CloudTemplate getTemplate(
			@ElementId("roleId") @Identity String roleId,
			@ElementId("templateId") @Identity String templateId
			) throws CloudManagerFault, InvalidUserPass, InvalidRole {
		return getResourceOperator(ITemplateOperator.class).findTemplate(templateId);
	}

	@Override
	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.READ)
	@CustomMethodValidation(AuthorizingValidator_role.class)
	public List<CloudTemplate> getTemplates(
			@ElementId("roleId") @Identity String roleId
			) throws CloudManagerFault, InvalidUserPass, InvalidRole {
		return getResourceOperator(ITemplateOperator.class).findAllTemplates();
	}

	@Override
	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.READ)
	@CustomMethodValidation(AuthorizingValidator_role.class)
	public List<String> getTemplateScripts(@ElementId("roleId") @Identity String roleId) throws CloudManagerFault {
		return getResourceOperator(ITemplateOperator.class).findTemplateScripts();
	}

	@Override
	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.WRITE)
	@CustomMethodValidation(AuthorizingValidator_is_administrator.class)
	public CloudAccountResource addAccountResource(
			@ElementId("CreateAccountResourceRequest") @NotNull @Into CreateAccountResourceRequest request
			) throws CloudManagerFault, InvalidUserPass, InvalidRole {
		IAccountResourceOperator cloudAccountResourceOperator = ObjectRegistryService.registry().get(IAccountResourceOperator.class);
		return cloudAccountResourceOperator.createCloudAccountResource(request);
	}

	@Override
	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.WRITE)
	@CustomMethodValidation(AuthorizingValidator_is_administrator.class)
	public CloudAccountResource modifyAccountResource(
			@ElementId("ModifyAccountResourceRequest") @NotNull @Into ModifyAccountResourceRequest request
			) throws CloudManagerFault, InvalidUserPass, InvalidRole {
		return ObjectRegistryService.registry().get(IAccountResourceOperator.class).modifyCloudAccountResource(request);
	}

	@Override
	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.WRITE)
	@CustomMethodValidation(AuthorizingValidator_is_administrator.class)
	public CloudAccountResource modifyAccountBillingDetail(
			@ElementId("ModifyAccountBillingDetailRequest") @NotNull @Into ModifyAccountBillingDetailRequest request)
			throws CloudManagerFault, InvalidUserPass, InvalidRole {
		return ObjectRegistryService.registry().get(IAccountResourceOperator.class).modifyAccountBillingDetail(request);
	}
	
	@Override
	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.WRITE)
	@CustomMethodValidation(AuthorizingValidator_is_administrator.class)
	public void removeAccountResource(
			@ElementId("accountResourceId") @NotNull @ModifiableAccountResource String accountResourceId)
			throws CloudManagerFault, InvalidUserPass, InvalidRole {
		ObjectRegistryService.registry().get(IAccountResourceOperator.class).removeCloudAccountResource(accountResourceId);
	}

	@Override
	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.READ)
	public CloudAccountResource getAccountResource(
			@ElementId("accountResourceId") @Identity String accountResourceId
			) throws CloudManagerFault, InvalidUserPass, InvalidRole {
		return ObjectRegistryService.registry().get(IAccountResourceOperator.class).findCloudAccountResourceByCurrentUser(accountResourceId);
	}

	@Override
	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.READ)
	public List<CloudAccountResource> getAllAccountResources() throws CloudManagerFault, InvalidUserPass, InvalidRole {
		return ObjectRegistryService.registry().get(IAccountResourceOperator.class).findCloudAccountResourcesByCurrentUser();
	}

//	@Override
//	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.WRITE)
//	public CloudService addCloudService(
//			@NotNull @Into CloudService cloudService
//			) throws CloudManagerFault, InvalidUserPass, InvalidRole {
//		ICloudServiceOperator cloudServiceOperator = ObjectSharingService.registry().get(ICloudServiceOperator.class);
//		return cloudServiceOperator.createCloudService(cloudService);
//	}
//
//	@Override
//	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.WRITE)
//	public void modifyCloudService(
//			@NotNull @Into CloudService cloudService
//			) throws CloudManagerFault, InvalidUserPass, InvalidRole {
//	}
//
//	@Override
//	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.WRITE)
//	public void removeCloudService(
//			@NotNull String cloudServiceId
//			) throws CloudManagerFault, InvalidUserPass, InvalidRole {
//	}

	@Override
	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.READ)
	public CloudService getCloudService(@ElementId("cloudServiceId") @Identity String cloudServiceId) throws CloudManagerFault, InvalidUserPass, InvalidRole {
		return ObjectRegistryService.registry().get(ICloudServiceOperator.class).findCloudService(cloudServiceId);
	}

	@Override
	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.READ)
	public List<CloudService> getAllCloudServices() throws CloudManagerFault, InvalidUserPass, InvalidRole {
		return ObjectRegistryService.registry().get(ICloudServiceOperator.class).findAllCloudService();
	}
	
	@Override
	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.READ)
	public List<CloudRegion> getCloudRegionsByService(@ElementId("cloudServiceId") @Identity String cloudServiceId) throws CloudManagerFault, InvalidUserPass, InvalidRole {
		return ObjectRegistryService.registry().get(ICloudServiceOperator.class).findCloudRegionsByService(cloudServiceId);
	}

	@Override
	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.READ)
	public List<String> getStorageFlavorsByService(@ElementId("cloudServiceId") @Identity String cloudServiceId) throws CloudManagerFault, InvalidUserPass, InvalidRole {
		ICloudServiceOperator operator = ObjectRegistryService.registry().get(ICloudServiceOperator.class);
		CloudService service = operator.findCloudService(cloudServiceId);
		IResourceManagement rm = ObjectRegistryService.registry().get(IResourceManagement.class, service.getCloudTypeId());
		if (rm == null) {
			throw ErrorCode.RESOURCEMANAGEMENT_NOT_FOUND.cloudManagerFault(cloudServiceId);
		}
		return rm.getStorageFlavors();
	}

	@Override
	public void start() {
	}

	@Override
	public void stop() {
	}

	@Override
	@HinemosAccessRight(roleName=CLOUDMANAGEMENT, right=SystemPrivilegeMode.READ)
	public List<String> getCloudServicesForBilling(@ElementId("accountResourceId") @Identity String accountResourceId) throws CloudManagerFault, InvalidUserPass, InvalidRole {
		return ObjectRegistryService.registry().get(IAccountResourceOperator.class).getCloudServicesForBilling(accountResourceId);
	}

	@Override
	@HinemosAccessRight(roleName=FunctionConstant.REPOSITORY, right=SystemPrivilegeMode.EXEC)
	public void establishAgentConnection(
			@ElementId("facilityId") @Identity String facilityId
			) throws CloudManagerFault, InvalidUserPass, InvalidRole {
		EntityManagerEx em = SessionService.current().getEntityManagerEx();
		Query query = em.createQuery("SELECT r FROM UserEntity h, RoleEntity r WHERE h.userId = :userId AND h MEMBER OF r.userEntities");
		query.setParameter("userId", SessionService.current().getHinemosCredential().getUserId());

		boolean accessable = false;
		List<?> results = query.getResultList();
		for (Object o: results) {
			try {
				FacilityTreeCache.validateFacilityId(facilityId, ((RoleEntity)o).getRoleId(), true);
				accessable = true;
				break;
			}
			catch (FacilityNotFound  e) {
				throw ErrorCode.HINEMOS_MANAGER_ERROR.cloudManagerFault(e);
			}
			catch (InvalidSetting | InvalidRole e) {
			}
		}
		
		if (!accessable) throw ErrorCode.NODE_DO_NOT_BE_ACCESSIBLE.cloudManagerFault(facilityId);
		
		InstanceOperator.asyncRegistAgent(facilityId);
	}
	
	@Override
	@HinemosAccessRights(
			{
				@HinemosAccessRight(roleName=FunctionConstant.REPOSITORY, right=SystemPrivilegeMode.READ),
				@HinemosAccessRight(roleName=FunctionConstant.CLOUDMANAGEMENT, right=SystemPrivilegeMode.READ)
			})
	public List<AvailableRole> getAvailableRoles() throws CloudManagerFault, InvalidUserPass, InvalidRole {
		Query query = null;
		List<String> excludes = Arrays.asList(RoleIdConstant.INTERNAL, RoleIdConstant.HINEMOS_MODULE);
		Boolean isAdministrator = (Boolean)HinemosSessionContext.instance().getProperty(HinemosSessionContext.IS_ADMINISTRATOR);
		if (isAdministrator == null || !isAdministrator) {
			EntityManagerEx em = SessionService.current().getEntityManagerEx();
			query = em.createQuery("SELECT r FROM RoleEntity AS r, UserEntity AS h WHERE r MEMBER OF h.roleEntities AND h.userId = :userId AND NOT r.roleId IN :excludes AND NOT r.roleId IN (SELECT c.roleId FROM CloudUserDao AS c)");
			query.setParameter("userId", SessionService.current().getHinemosCredential().getUserId());
			query.setParameter("excludes", excludes);
		}
		else {
			EntityManagerEx em = SessionService.current().getEntityManagerEx();
			query = em.createQuery("SELECT r FROM RoleEntity AS r WHERE NOT r.roleId IN :excludes AND NOT r.roleId IN (SELECT c.roleId FROM CloudUserDao AS c)");
			query.setParameter("excludes", excludes);
		}
		List<AvailableRole> availableRoles = new ArrayList<>();

		@SuppressWarnings("unchecked")
		List<RoleEntity> roles = (List<RoleEntity>)query.getResultList();
		for (RoleEntity r: roles) {
			availableRoles.add(new AvailableRole(r.getRoleId(), r.getRoleName()));
		}
		return availableRoles;
	}
}