/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.accesscontrol.composite;

import com.clustercontrol.accesscontrol.action.GetObjectPrivilegeListTableDefine;
import com.clustercontrol.accesscontrol.util.ObjectPrivilegeBean;
import com.clustercontrol.viewer.CommonTableViewer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class ObjectPrivilegeListComposite
extends Composite {
    private static Log m_log = LogFactory.getLog(ObjectPrivilegeListComposite.class);
    private CommonTableViewer m_viewer = null;
    private Label m_labelType = null;
    private Label m_labelCount = null;
    private Object m_data = null;
    private String m_objectId = "";
    private String m_objectType = "";
    private HashMap<String, ObjectPrivilegeBean> m_objPrivMap = null;

    public ObjectPrivilegeListComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize(false);
    }

    public ObjectPrivilegeListComposite(Composite parent, int style, HashMap<String, ObjectPrivilegeBean> objPrivMap) {
        super(parent, style);
        this.m_objPrivMap = objPrivMap;
        this.initialize(false);
    }

    private void initialize(boolean flg) {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Table table = new Table((Composite)this, 66306);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        table.setLayoutData((Object)gridData);
        this.m_viewer = new CommonTableViewer(table);
        this.m_viewer.createTableColumn(GetObjectPrivilegeListTableDefine.get(), 0, 1);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.update();
    }

    public void update() {
        ArrayList inputList = new ArrayList();
        ObjectPrivilegeBean bean = null;
        if (this.m_objPrivMap == null) {
            return;
        }
        for (Map.Entry<String, ObjectPrivilegeBean> keyValue : this.m_objPrivMap.entrySet()) {
            bean = keyValue.getValue();
            ArrayList<Object> a = new ArrayList<Object>();
            a.add(bean.getRoleId());
            if (bean.getReadPrivilege()) {
                a.add(true);
            } else {
                a.add(false);
            }
            if (bean.getWritePrivilege()) {
                a.add(true);
            } else {
                a.add(false);
            }
            if (bean.getExecPrivilege()) {
                a.add(true);
            } else {
                a.add(false);
            }
            inputList.add(a);
        }
        this.m_viewer.setInput(inputList);
    }

    public void objectPrivilegeRefresh(HashMap<String, ObjectPrivilegeBean> map) {
        this.m_objPrivMap = map;
        this.update();
    }

    public TableViewer getTableViewer() {
        return this.m_viewer;
    }

    public Table getTable() {
        return this.m_viewer.getTable();
    }

    public Object getData() {
        return this.m_data;
    }

    public void setData(Object data) {
        this.m_data = data;
    }
}

