/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.accesscontrol.composite;

import com.clustercontrol.accesscontrol.action.GetSystemPrivilegeListTableDefine;
import com.clustercontrol.accesscontrol.util.AccessEndpointWrapper;
import com.clustercontrol.accesscontrol.util.SystemPrivilegePropertyUtil;
import com.clustercontrol.util.Messages;
import com.clustercontrol.viewer.CommonTableViewer;
import com.clustercontrol.ws.access.InvalidRole_Exception;
import com.clustercontrol.ws.access.RoleInfo;
import com.clustercontrol.ws.access.SystemPrivilegeInfo;
import com.clustercontrol.ws.access.UserInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class SystemPrivilegeListComposite
extends Composite {
    private static Log m_log = LogFactory.getLog(SystemPrivilegeListComposite.class);
    private CommonTableViewer m_viewer = null;
    private Label m_labelType = null;
    private Label m_labelCount = null;
    private Object m_data = null;

    public SystemPrivilegeListComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.m_labelType = new Label((Composite)this, 16384);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.m_labelType.setLayoutData((Object)gridData);
        Table table = new Table((Composite)this, 66308);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        table.setLayoutData((Object)gridData);
        this.m_labelCount = new Label((Composite)this, 131072);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.m_labelCount.setLayoutData((Object)gridData);
        this.m_viewer = new CommonTableViewer(table);
        this.m_viewer.createTableColumn(GetSystemPrivilegeListTableDefine.get(), 0, 1);
    }

    public void update() {
        this.update(null);
    }

    public void update(Object selectedInfo) {
        List<SystemPrivilegeInfo> infoList = null;
        try {
            if (selectedInfo != null) {
                if (selectedInfo instanceof RoleInfo) {
                    if (!((RoleInfo)selectedInfo).getId().equals("root")) {
                        infoList = AccessEndpointWrapper.getSystemPrivilegeInfoListByRoleId(((RoleInfo)selectedInfo).getId());
                    }
                } else if (selectedInfo instanceof UserInfo) {
                    infoList = AccessEndpointWrapper.getSystemPrivilegeInfoListByUserId(((UserInfo)selectedInfo).getId());
                }
            }
        }
        catch (InvalidRole_Exception invalidRole_Exception) {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
        }
        catch (Exception e) {
            m_log.warn((Object)("update(), " + e.getMessage()), (Throwable)e);
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
        }
        ArrayList listInput = new ArrayList();
        if (selectedInfo != null && infoList != null) {
            for (SystemPrivilegeInfo info : infoList) {
                ArrayList<String> obj = new ArrayList<String>();
                obj.add(SystemPrivilegePropertyUtil.getValue(info.getSystemFunction(), info.getSystemPrivilege()));
                listInput.add(obj);
            }
        }
        this.m_viewer.setInput(listInput);
        Object[] args = new Object[]{new Integer(listInput.size())};
        if (selectedInfo == null) {
            this.m_labelType.setText("");
            this.m_labelCount.setText(Messages.getString((String)"records", (Object[])args));
        } else if (selectedInfo instanceof RoleInfo) {
            if (((RoleInfo)selectedInfo).getId().equals("root")) {
                this.m_labelType.setText("");
                this.m_labelCount.setText(Messages.getString((String)"records", (Object[])args));
            } else {
                RoleInfo roleInfo = (RoleInfo)selectedInfo;
                this.m_labelType.setText(String.valueOf(Messages.getString((String)"role.name")) + " : " + roleInfo.getName() + "(" + roleInfo.getId() + ")");
                this.m_labelCount.setText(Messages.getString((String)"filtered.records", (Object[])args));
            }
        } else if (selectedInfo instanceof UserInfo) {
            UserInfo userInfo = (UserInfo)selectedInfo;
            this.m_labelType.setText(String.valueOf(Messages.getString((String)"user.name")) + " : " + userInfo.getName() + "(" + userInfo.getId() + ")");
            this.m_labelCount.setText(Messages.getString((String)"filtered.records", (Object[])args));
        }
    }

    public TableViewer getTableViewer() {
        return this.m_viewer;
    }

    public Table getTable() {
        return this.m_viewer.getTable();
    }

    public Object getData() {
        return this.m_data;
    }

    public void setData(Object data) {
        this.m_data = data;
    }
}

