/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.accesscontrol.composite;

import com.clustercontrol.accesscontrol.action.GetUserListTableDefine;
import com.clustercontrol.accesscontrol.composite.action.UserDoubleClickListener;
import com.clustercontrol.accesscontrol.util.AccessEndpointWrapper;
import com.clustercontrol.bean.Property;
import com.clustercontrol.util.Messages;
import com.clustercontrol.viewer.CommonTableViewer;
import com.clustercontrol.ws.access.InvalidRole_Exception;
import com.clustercontrol.ws.access.UserInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class UserListComposite
extends Composite {
    private static Log m_log = LogFactory.getLog(UserListComposite.class);
    private CommonTableViewer m_viewer = null;
    private Label m_labelType = null;
    private Label m_labelCount = null;
    private String m_uid = null;

    public UserListComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.m_labelType = new Label((Composite)this, 16384);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.m_labelType.setLayoutData((Object)gridData);
        Table table = new Table((Composite)this, 66308);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        table.setLayoutData((Object)gridData);
        this.m_labelCount = new Label((Composite)this, 131072);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.m_labelCount.setLayoutData((Object)gridData);
        this.m_viewer = new CommonTableViewer(table);
        this.m_viewer.createTableColumn(GetUserListTableDefine.get(), 0, 1);
        this.m_viewer.addDoubleClickListener(new UserDoubleClickListener(this));
    }

    public void update() {
        List<UserInfo> infoList = null;
        try {
            infoList = AccessEndpointWrapper.getUserInfoList();
        }
        catch (InvalidRole_Exception invalidRole_Exception) {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
            infoList = this.getOwnUserList();
        }
        catch (Exception e) {
            m_log.warn((Object)("update(), " + e.getMessage()), (Throwable)e);
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
        }
        ArrayList listInput = new ArrayList();
        for (UserInfo info : infoList) {
            ArrayList<Object> obj = new ArrayList<Object>();
            obj.add(info.getId());
            obj.add(info.getName());
            obj.add(info.getDescription());
            obj.add(info.getCreateUserId());
            obj.add(new Date(info.getCreateDate()));
            obj.add(info.getModifyUserId());
            obj.add(new Date(info.getModifyDate()));
            listInput.add(obj);
        }
        this.m_viewer.setInput(listInput);
        Object[] args = new Object[]{new Integer(listInput.size())};
        this.m_labelType.setText("");
        this.m_labelCount.setText(Messages.getString((String)"records", (Object[])args));
    }

    public void update(Property condition) {
    }

    public TableViewer getTableViewer() {
        return this.m_viewer;
    }

    public Table getTable() {
        return this.m_viewer.getTable();
    }

    public String getUid() {
        return this.m_uid;
    }

    public void setUid(String uid) {
        this.m_uid = uid;
    }

    public List<UserInfo> getOwnUserList() {
        ArrayList<UserInfo> infoList = new ArrayList<UserInfo>();
        UserInfo info = null;
        try {
            info = AccessEndpointWrapper.getOwnUserInfo();
        }
        catch (InvalidRole_Exception invalidRole_Exception) {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
        }
        catch (Exception e) {
            m_log.warn((Object)("getOwnUserList(), " + e.getMessage()), (Throwable)e);
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
        }
        if (info == null) {
            info = new UserInfo();
            info.setCreateDate(Long.valueOf(0L));
            info.setModifyDate(Long.valueOf(0L));
        }
        infoList.add(info);
        return infoList;
    }
}

