/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.accesscontrol.dialog;

import com.clustercontrol.accesscontrol.composite.ObjectPrivilegeListComposite;
import com.clustercontrol.accesscontrol.dialog.ObjectPrivilegeEditDialog;
import com.clustercontrol.accesscontrol.util.ObjectBean;
import com.clustercontrol.accesscontrol.util.ObjectPrivilegeBean;
import com.clustercontrol.accesscontrol.util.RoleObjectPrivilegeUtil;
import com.clustercontrol.bean.HinemosModuleConstant;
import com.clustercontrol.calendar.dialog.CalendarDialog;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ObjectPrivilegeListDialog
extends CommonDialog {
    private static Log m_log = LogFactory.getLog(CalendarDialog.class);
    private String m_objectId = "";
    private String m_objectType = "";
    private String m_ownerRoleId = "";
    private ObjectPrivilegeListComposite m_objectPrivilegeListComposite = null;
    private HashMap<String, ObjectPrivilegeBean> m_objPrivMap = null;
    private Shell shell = null;

    public ObjectPrivilegeListDialog(Shell parent) {
        super(parent);
    }

    public ObjectPrivilegeListDialog(Shell parent, String objectId, String objectType, String m_ownerRoleId) {
        super(parent);
        this.m_objectId = objectId;
        this.m_objectType = objectType;
        this.m_ownerRoleId = m_ownerRoleId;
        this.m_objPrivMap = RoleObjectPrivilegeUtil.dto2beanMap(this.m_objectId, this.m_objectType);
    }

    @Override
    protected void customizeDialog(Composite parent) {
        this.shell = this.getShell();
        String objectName = HinemosModuleConstant.nameToString((String)this.m_objectType);
        this.shell.setText(String.valueOf(objectName) + Messages.getString((String)"dialog.accesscontrol.object.privilege.list"));
        GridData gridData = new GridData();
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        parent.setLayout((Layout)layout);
        Label lblObjID = new Label(parent, 16384);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        lblObjID.setLayoutData((Object)gridData);
        lblObjID.setText(String.valueOf(objectName) + Messages.getString((String)"id") + " : " + this.m_objectId);
        Label lblOwnerId = new Label(parent, 16384);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        lblOwnerId.setLayoutData((Object)gridData);
        lblOwnerId.setText(String.valueOf(Messages.getString((String)"owner.role.id")) + " : " + this.m_ownerRoleId);
        this.m_objectPrivilegeListComposite = new ObjectPrivilegeListComposite(parent, 0, this.m_objPrivMap);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 220;
        this.m_objectPrivilegeListComposite.setLayoutData(gridData);
        Display display = this.shell.getDisplay();
        this.shell.setLocation((display.getBounds().width - this.shell.getSize().x) / 2, (display.getBounds().height - this.shell.getSize().y) / 2);
        this.adjustDialog();
    }

    private void adjustDialog() {
        this.shell.pack();
        this.shell.setSize(new Point(600, this.shell.getSize().y));
        Display display = this.shell.getDisplay();
        this.shell.setLocation((display.getBounds().width - this.shell.getSize().x) / 2, (display.getBounds().height - this.shell.getSize().y) / 2);
    }

    public void update() {
        this.m_objPrivMap = RoleObjectPrivilegeUtil.dto2beanMap(this.m_objectId, this.m_objectType);
        this.m_objectPrivilegeListComposite.objectPrivilegeRefresh(this.m_objPrivMap);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 11, Messages.getString((String)"edit"), false);
        this.getButton(11).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArrayList<ObjectBean> objectBeans = new ArrayList<ObjectBean>();
                objectBeans.add(new ObjectBean(ObjectPrivilegeListDialog.this.m_objectType, ObjectPrivilegeListDialog.this.m_objectId));
                ObjectPrivilegeEditDialog dialog = new ObjectPrivilegeEditDialog(ObjectPrivilegeListDialog.this.getParentShell(), objectBeans, ObjectPrivilegeListDialog.this.m_ownerRoleId, ObjectPrivilegeListDialog.this.m_objPrivMap);
                dialog.open();
                ObjectPrivilegeListDialog.this.update();
            }
        });
        this.createButton(parent, 1, IDialogConstants.CLOSE_LABEL, false);
    }
}

