/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.accesscontrol.view.action;

import com.clustercontrol.accesscontrol.dialog.ModifyPasswordDialog;
import com.clustercontrol.accesscontrol.etc.action.LogoutAction;
import com.clustercontrol.accesscontrol.util.AccessEndpointWrapper;
import com.clustercontrol.accesscontrol.view.UserListView;
import com.clustercontrol.util.LoginManager;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.access.InvalidRole_Exception;
import java.security.MessageDigest;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class ModifyPasswordAction
implements IViewActionDelegate {
    public static final String ID = "com.clustercontrol.accesscontrol.view.action.ModifyPasswordAction";
    private IViewPart viewPart;

    public void init(IViewPart view) {
        this.viewPart = view;
    }

    public void run(IAction action) {
        UserListView view = (UserListView)((Object)this.viewPart.getAdapter(UserListView.class));
        StructuredSelection selection = (StructuredSelection)view.getComposite().getTableViewer().getSelection();
        List list = (List)selection.getFirstElement();
        String uid = null;
        if (list != null) {
            uid = (String)list.get(0);
        }
        if (uid != null) {
            ModifyPasswordDialog dialog = new ModifyPasswordDialog(this.viewPart.getSite().getShell());
            dialog.setUserid(uid);
            if (dialog.open() == 0) {
                String password = dialog.getPassword();
                String userId = LoginManager.getUserId();
                try {
                    String passwordHash = Base64.encodeBase64String((byte[])MessageDigest.getInstance("MD5").digest(password.getBytes()));
                    if (uid.equals(userId)) {
                        AccessEndpointWrapper.changeOwnPassword(passwordHash);
                    } else {
                        AccessEndpointWrapper.changePassword(uid, passwordHash);
                    }
                    MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)Messages.getString((String)"message.accesscontrol.14"));
                    if (uid.equals(userId)) {
                        MessageDialog.openInformation(null, (String)Messages.getString((String)"info"), (String)Messages.getString((String)"message.accesscontrol.25"));
                        new LogoutAction().runLogout();
                        return;
                    }
                }
                catch (Exception e) {
                    String errMessage = "";
                    if (e instanceof InvalidRole_Exception) {
                        MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                    } else {
                        errMessage = ", " + e.getMessage();
                    }
                    MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.accesscontrol.15")) + errMessage));
                }
                view.update();
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

