/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.calendar.composite;

import com.clustercontrol.calendar.action.GetCalendarListTableDefine;
import com.clustercontrol.calendar.composite.action.CalendarDoubleClickListener;
import com.clustercontrol.calendar.composite.action.CalendarSelectionChangedListener;
import com.clustercontrol.calendar.composite.action.VerticalBarSelectionListener;
import com.clustercontrol.calendar.util.CalendarEndpointWrapper;
import com.clustercontrol.util.Messages;
import com.clustercontrol.viewer.CommonTableViewer;
import com.clustercontrol.ws.calendar.CalendarInfo;
import com.clustercontrol.ws.calendar.InvalidRole_Exception;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class CalendarListComposite
extends Composite {
    private static Log m_log = LogFactory.getLog(CalendarListComposite.class);
    private CommonTableViewer m_viewer = null;
    private Table m_table = null;
    private Label m_labelCount = null;
    private String m_calendarId = null;

    public TableViewer getTableViewer() {
        return this.m_viewer;
    }

    public Table getTable() {
        return this.m_viewer.getTable();
    }

    public String getCalendarId() {
        return this.m_calendarId;
    }

    public void setCalendarId(String calendarId) {
        this.m_calendarId = calendarId;
    }

    public CalendarListComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.m_table = new Table((Composite)this, 68354);
        this.m_table.setHeaderVisible(true);
        this.m_table.setLinesVisible(true);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        this.m_table.setLayoutData((Object)gridData);
        this.m_labelCount = new Label((Composite)this, 131072);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.m_labelCount.setLayoutData((Object)gridData);
        this.m_viewer = new CommonTableViewer(this.m_table);
        this.m_viewer.createTableColumn(GetCalendarListTableDefine.get(), 0, 1);
        this.m_viewer.addSelectionChangedListener(new CalendarSelectionChangedListener(this));
        this.m_viewer.addDoubleClickListener(new CalendarDoubleClickListener(this));
        this.m_viewer.getTable().getVerticalBar().addSelectionListener((SelectionListener)new VerticalBarSelectionListener(this));
    }

    public void update() {
        List<CalendarInfo> list = null;
        try {
            list = CalendarEndpointWrapper.getAllCalendarList();
        }
        catch (InvalidRole_Exception invalidRole_Exception) {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
        }
        catch (Exception e) {
            m_log.warn((Object)("update(), " + e.getMessage()), (Throwable)e);
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
        }
        if (list == null) {
            list = new ArrayList<CalendarInfo>();
        }
        ArrayList listInput = new ArrayList();
        for (CalendarInfo info : list) {
            ArrayList<Object> obj = new ArrayList<Object>();
            obj.add(info.getId());
            obj.add(info.getName());
            obj.add(new Date(info.getValidTimeFrom()));
            obj.add(new Date(info.getValidTimeTo()));
            obj.add(info.getDescription());
            obj.add(info.getOwnerRoleId());
            obj.add(info.getRegUser());
            obj.add(new Date(info.getRegDate()));
            obj.add(info.getUpdateUser());
            obj.add(new Date(info.getUpdateDate()));
            listInput.add(obj);
        }
        this.m_viewer.setInput(listInput);
        Object[] args = new Object[]{new Integer(list.size())};
        this.m_labelCount.setText(Messages.getString((String)"records", (Object[])args));
    }
}

