/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.calendar.composite;

import com.clustercontrol.calendar.action.GetCalendarMonthTableDefine;
import com.clustercontrol.calendar.composite.action.VerticalBarSelectionListener;
import com.clustercontrol.calendar.util.CalendarEndpointWrapper;
import com.clustercontrol.calendar.view.CalendarWeekView;
import com.clustercontrol.calendar.viewer.CalendarMonthTableViewer;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.calendar.CalendarNotFound_Exception;
import com.clustercontrol.ws.calendar.InvalidRole_Exception;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class CalendarMonthComposite
extends Composite {
    private static Log m_log = LogFactory.getLog(CalendarMonthComposite.class);
    private CalendarMonthTableViewer m_viewer = null;
    private Label m_labelId = null;
    private Table m_table = null;
    private String m_calendarId = null;
    private int nowYear;
    private int nowMonth;
    private Label yearMonth = null;
    private int selectedDay = 32;
    private List<Integer> m_summaryInfo = null;
    private static Font yearMonthFont = null;
    private static Font normalFont = null;
    private static Font boldFont = null;
    private final String fontStr = "MS UI Gothic";

    public TableViewer getTableViewer() {
        return this.m_viewer;
    }

    public Table getTable() {
        return this.m_viewer.getTable();
    }

    public String getCalendarId() {
        return this.m_calendarId;
    }

    public void setCalendarId(String calendarId) {
        this.m_calendarId = calendarId;
    }

    public CalendarMonthComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 15;
        this.m_labelId = new Label((Composite)this, 16384);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 15;
        this.m_labelId.setText(String.valueOf(Messages.getString((String)"calendar.id")) + " : ");
        this.m_labelId.setLayoutData((Object)gridData);
        Button backYear = new Button((Composite)this, 0);
        backYear.setText(Messages.getString((String)"view.calendar.month.previous.year"));
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        backYear.setLayoutData((Object)gridData);
        backYear.setToolTipText(Messages.getString((String)"view.calendar.month.previous.year.text"));
        backYear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CalendarMonthComposite.this.nowYear <= 0) {
                    return;
                }
                CalendarMonthComposite calendarMonthComposite = CalendarMonthComposite.this;
                calendarMonthComposite.nowYear = calendarMonthComposite.nowYear - 1;
                CalendarMonthComposite.this.updateMonth();
            }
        });
        Button backMonth = new Button((Composite)this, 0);
        backMonth.setText(Messages.getString((String)"view.calendar.month.previous.month"));
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        backMonth.setLayoutData((Object)gridData);
        backMonth.setLayoutData((Object)gridData);
        backMonth.setToolTipText(Messages.getString((String)"view.calendar.month.previous.month.text"));
        backMonth.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CalendarMonthComposite.this.nowMonth <= 0 || CalendarMonthComposite.this.nowYear <= 0) {
                    return;
                }
                if (CalendarMonthComposite.this.nowMonth == 1) {
                    CalendarMonthComposite.this.nowMonth = 12;
                    CalendarMonthComposite calendarMonthComposite = CalendarMonthComposite.this;
                    calendarMonthComposite.nowYear = calendarMonthComposite.nowYear - 1;
                } else {
                    CalendarMonthComposite calendarMonthComposite = CalendarMonthComposite.this;
                    calendarMonthComposite.nowMonth = calendarMonthComposite.nowMonth - 1;
                }
                CalendarMonthComposite.this.updateMonth();
            }
        });
        this.yearMonth = new Label((Composite)this, 0x1000000);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 2;
        this.yearMonth.setText(Messages.getString((String)"----/--"));
        if (yearMonthFont == null) {
            yearMonthFont = new Font((Device)this.getDisplay(), "MS UI Gothic", 15, 300);
        }
        this.yearMonth.setFont(yearMonthFont);
        this.yearMonth.setLayoutData((Object)gridData);
        Button goMonth = new Button((Composite)this, 0);
        goMonth.setText(Messages.getString((String)"view.calendar.month.next.month"));
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        goMonth.setLayoutData((Object)gridData);
        goMonth.setToolTipText(Messages.getString((String)"view.calendar.month.next.month.text"));
        goMonth.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CalendarMonthComposite.this.nowMonth <= 0 || CalendarMonthComposite.this.nowYear <= 0) {
                    return;
                }
                if (CalendarMonthComposite.this.nowMonth == 12) {
                    CalendarMonthComposite.this.nowMonth = 1;
                    CalendarMonthComposite calendarMonthComposite = CalendarMonthComposite.this;
                    calendarMonthComposite.nowYear = calendarMonthComposite.nowYear + 1;
                } else {
                    CalendarMonthComposite calendarMonthComposite = CalendarMonthComposite.this;
                    calendarMonthComposite.nowMonth = calendarMonthComposite.nowMonth + 1;
                }
                CalendarMonthComposite.this.updateMonth();
            }
        });
        Button goYear = new Button((Composite)this, 0);
        goYear.setText(Messages.getString((String)"view.calendar.month.next.year"));
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        goYear.setLayoutData((Object)gridData);
        goYear.setToolTipText(Messages.getString((String)"view.calendar.month.next.year.text"));
        goYear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CalendarMonthComposite.this.nowYear <= 0) {
                    return;
                }
                CalendarMonthComposite calendarMonthComposite = CalendarMonthComposite.this;
                calendarMonthComposite.nowYear = calendarMonthComposite.nowYear + 1;
                CalendarMonthComposite.this.updateMonth();
            }
        });
        this.m_table = new Table((Composite)this, 34820);
        this.m_table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CalendarMonthComposite.this.m_table.setSelection(-1);
            }
        });
        this.createTableColAndContents(this.m_table);
        this.m_table.setHeaderVisible(true);
        this.m_table.setLinesVisible(true);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 15;
        this.m_table.setLayoutData((Object)gridData);
        this.m_viewer = new CalendarMonthTableViewer(this.m_table);
        this.m_viewer.createTableColumn(GetCalendarMonthTableDefine.get());
        this.m_viewer.getTable().getVerticalBar().addSelectionListener((SelectionListener)new VerticalBarSelectionListener(this));
    }

    private void createTableColAndContents(Table table) {
        final TableCursor cursor = new TableCursor(table, 0);
        ControlEditor editor = new ControlEditor((Composite)cursor);
        editor.grabHorizontal = true;
        editor.grabVertical = true;
        cursor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IWorkbenchPage page;
                IViewPart viewPart;
                int column;
                TableItem row = cursor.getRow();
                String strDay = row.getText(column = cursor.getColumn());
                if (strDay != "") {
                    CalendarMonthComposite.this.selectedDay = Integer.parseInt(strDay.replaceAll("[^0-9]", ""));
                }
                CalendarMonthComposite.this.update();
                if (CalendarMonthComposite.this.selectedDay != 0 && (viewPart = (page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()).findView("com.clustercontrol.calendar.view.CalendarWeekView")) != null) {
                    CalendarWeekView view = (CalendarWeekView)((Object)viewPart.getAdapter(CalendarWeekView.class));
                    view.update(CalendarMonthComposite.this.m_calendarId, CalendarMonthComposite.this.nowYear, CalendarMonthComposite.this.nowMonth, CalendarMonthComposite.this.selectedDay);
                }
            }
        });
    }

    public void init(String calendarId) {
        if (calendarId == null) {
            return;
        }
        if (calendarId != null && calendarId.length() > 0) {
            this.m_calendarId = calendarId;
            this.m_labelId.setText(String.valueOf(Messages.getString((String)"calendar.id")) + " : " + calendarId);
        } else {
            this.m_labelId.setText(String.valueOf(Messages.getString((String)"calendar.id")) + " : ");
        }
        Date date = new Date();
        SimpleDateFormat sdf = null;
        sdf = new SimpleDateFormat("yyyy");
        this.nowYear = Integer.parseInt(sdf.format(date));
        sdf = new SimpleDateFormat("MM");
        this.nowMonth = Integer.parseInt(sdf.format(date));
        this.updateMonth();
    }

    private void updateMonth() {
        this.selectedDay = 32;
        try {
            this.m_summaryInfo = CalendarEndpointWrapper.getCalendarMonth(this.m_calendarId, this.nowYear, this.nowMonth);
        }
        catch (InvalidRole_Exception invalidRole_Exception) {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
        }
        catch (CalendarNotFound_Exception e) {
            m_log.info((Object)("update(), " + e.getMessage()));
        }
        catch (Exception e) {
            m_log.warn((Object)("update(), " + e.getMessage()), (Throwable)e);
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
            return;
        }
        this.update();
    }

    public void update() {
        if (this.m_calendarId == null || this.m_summaryInfo == null) {
            return;
        }
        this.yearMonth.setText(String.format("%04d/%02d", this.nowYear, this.nowMonth));
        Calendar calendar = null;
        calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(this.nowYear, this.nowMonth - 1, 1);
        int startDate = calendar.get(7);
        int lastDate = this.m_summaryInfo.size() + 1;
        this.m_table.removeAll();
        int day = 1;
        int i = 0;
        while (i < 6) {
            int j = startDate;
            startDate = 1;
            String[] days = new String[8];
            TableItem tableItem = new TableItem(this.m_table, 0);
            while (j < days.length && day < lastDate) {
                String sign = "";
                boolean selectedFlag = false;
                if (this.selectedDay <= day && day < this.selectedDay + 7) {
                    selectedFlag = true;
                }
                switch (this.m_summaryInfo.get(day - 1)) {
                    case 0: {
                        sign = Messages.getString((String)"view.calendar.month.all");
                        tableItem.setBackground(j, ColorConstants.green);
                        break;
                    }
                    case 1: {
                        sign = Messages.getString((String)"view.calendar.month.part");
                        tableItem.setBackground(j, ColorConstants.yellow);
                        break;
                    }
                    case 2: {
                        sign = Messages.getString((String)"view.calendar.month.none");
                        tableItem.setBackground(j, ColorConstants.red);
                    }
                }
                if (normalFont == null) {
                    normalFont = new Font((Device)this.getDisplay(), "MS UI Gothic", 10, 0);
                }
                if (boldFont == null) {
                    boldFont = new Font((Device)this.getDisplay(), "MS UI Gothic", 10, 1);
                }
                if (selectedFlag) {
                    tableItem.setFont(j, boldFont);
                } else {
                    tableItem.setFont(j, normalFont);
                }
                tableItem.setForeground(j, ColorConstants.black);
                days[j] = String.valueOf(String.format("%02d", day)) + sign;
                ++j;
                ++day;
            }
            tableItem.setText(days);
            ++i;
        }
    }
}

