/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.calendar.dialog;

import com.clustercontrol.bean.DayOfWeekConstant;
import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.calendar.bean.DayOfWeekInMonthConstant;
import com.clustercontrol.calendar.bean.MonthConstant;
import com.clustercontrol.calendar.util.CalendarEndpointWrapper;
import com.clustercontrol.composite.action.NumberKeyListener;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.calendar.CalendarDetailInfo;
import com.clustercontrol.ws.calendar.CalendarPatternInfo;
import com.clustercontrol.ws.calendar.InvalidRole_Exception;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CalendarDetailDialog
extends CommonDialog {
    private static Log m_log = LogFactory.getLog(CalendarDetailDialog.class);
    private final int DIALOG_WIDTH = 8;
    private CalendarDetailInfo inputData = null;
    private ValidateResult m_validateResult = null;
    private Shell shell = null;
    private Group groupYear = null;
    private Group groupMonth = null;
    private Group groupDate = null;
    private Group groupAfterDate = null;
    private Group groupTime = null;
    private Group groupOperate = null;
    private Button radioEveryYear = null;
    private Button radioSpecifyYear = null;
    private Button radioAllDay = null;
    private Button radioDayOfWeek = null;
    private Button radioDate = null;
    private Button radioCalPattern = null;
    private Button radioOperateON = null;
    private Button radioOperateOFF = null;
    private Combo cmbMonth = null;
    private Combo cmbDayOfWeek = null;
    private Combo cmbDayOfWeekInMonth = null;
    private Combo cmbDays = null;
    private Combo cmbCalPattern = null;
    private Text txtDescription = null;
    private Text txtYear = null;
    private Text txtDaysLater = null;
    private Text txtTimeFrom = null;
    private Text txtTimeTo = null;
    private String ownerRoleId = null;

    public CalendarDetailInfo getInputData() {
        return this.inputData;
    }

    public CalendarDetailDialog(Shell parent, String ownerRoleId) {
        super(parent);
        this.ownerRoleId = ownerRoleId;
    }

    public CalendarDetailDialog(Shell parent, int order, String ownerRoleId) {
        super(parent);
        this.ownerRoleId = ownerRoleId;
    }

    public CalendarDetailDialog(Shell parent, CalendarDetailInfo detailInfo, String ownerRoleId) {
        super(parent);
        this.inputData = detailInfo;
        this.ownerRoleId = ownerRoleId;
    }

    @Override
    protected void customizeDialog(Composite parent) {
        this.shell = this.getShell();
        this.shell.setText(Messages.getString((String)"dialog.calendar.detail.create.modify"));
        GridData gridData = new GridData();
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 8;
        parent.setLayout((Layout)layout);
        Label label = new Label(parent, 16384);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText("  " + Messages.getString((String)"description"));
        this.txtDescription = new Text(parent, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.txtDescription.setLayoutData((Object)gridData);
        this.txtDescription.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                CalendarDetailDialog.this.update();
            }
        });
        this.groupYear = new Group(parent, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 8;
        this.groupYear.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.groupYear.setLayoutData((Object)gridData);
        this.groupYear.setText(Messages.getString((String)"year"));
        this.radioEveryYear = new Button((Composite)this.groupYear, 16);
        this.radioEveryYear.setText(Messages.getString((String)"calendar.detail.every.year"));
        GridData gridYearRadio = new GridData();
        gridYearRadio.horizontalSpan = 8;
        gridYearRadio.horizontalAlignment = 4;
        gridYearRadio.grabExcessHorizontalSpace = true;
        this.radioEveryYear.setLayoutData((Object)gridYearRadio);
        this.radioEveryYear.setSelection(true);
        this.radioEveryYear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CalendarDetailDialog.this.update();
            }
        });
        this.radioSpecifyYear = new Button((Composite)this.groupYear, 16);
        this.radioSpecifyYear.setText(Messages.getString((String)"calendar.detail.specify.year"));
        gridYearRadio = new GridData();
        gridYearRadio.horizontalSpan = 3;
        gridYearRadio.horizontalAlignment = 4;
        gridYearRadio.grabExcessHorizontalSpace = true;
        this.radioSpecifyYear.setLayoutData((Object)gridYearRadio);
        this.radioSpecifyYear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CalendarDetailDialog.this.update();
            }
        });
        this.txtYear = new Text((Composite)this.groupYear, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.txtYear.setLayoutData((Object)gridData);
        this.txtYear.setTextLimit(4);
        this.txtYear.addKeyListener((KeyListener)new NumberKeyListener());
        this.txtYear.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                if ("-".equals(CalendarDetailDialog.this.txtYear.getText())) {
                    CalendarDetailDialog.this.txtYear.setText("");
                }
                CalendarDetailDialog.this.update();
            }
        });
        label = new Label((Composite)this.groupYear, 16384);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString((String)"year"));
        this.groupMonth = new Group(parent, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 8;
        this.groupMonth.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.groupMonth.setLayoutData((Object)gridData);
        this.groupMonth.setText(Messages.getString((String)"month"));
        Label lblCalID = new Label((Composite)this.groupMonth, 16384);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        lblCalID.setLayoutData((Object)gridData);
        lblCalID.setText(Messages.getString((String)"month"));
        this.cmbMonth = new Combo((Composite)this.groupMonth, 133128);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.cmbMonth.setLayoutData((Object)gridData);
        int i = 0;
        while (i < 13) {
            this.cmbMonth.add(MonthConstant.typeToString(i));
            ++i;
        }
        this.cmbMonth.setText(MonthConstant.typeToString(0));
        this.groupDate = new Group(parent, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 8;
        this.groupDate.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.groupDate.setLayoutData((Object)gridData);
        this.groupDate.setText(Messages.getString((String)"monthday"));
        this.radioAllDay = new Button((Composite)this.groupDate, 16);
        this.radioAllDay.setText(Messages.getString((String)"calendar.detail.everyday"));
        GridData gridDataRadio = new GridData();
        gridDataRadio.horizontalSpan = 3;
        gridDataRadio.horizontalAlignment = 4;
        gridDataRadio.grabExcessHorizontalSpace = true;
        this.radioAllDay.setLayoutData((Object)gridDataRadio);
        this.radioAllDay.setSelection(true);
        this.radioAllDay.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CalendarDetailDialog.this.update();
            }
        });
        label = new Label((Composite)this.groupDate, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.radioDayOfWeek = new Button((Composite)this.groupDate, 16);
        this.radioDayOfWeek.setText(Messages.getString((String)"weekday"));
        gridDataRadio = new GridData();
        gridDataRadio.horizontalSpan = 3;
        gridDataRadio.horizontalAlignment = 4;
        gridDataRadio.grabExcessHorizontalSpace = true;
        this.radioDayOfWeek.setLayoutData((Object)gridDataRadio);
        this.radioDayOfWeek.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CalendarDetailDialog.this.update();
            }
        });
        this.cmbDayOfWeekInMonth = new Combo((Composite)this.groupDate, 133128);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.cmbDayOfWeekInMonth.setLayoutData((Object)gridData);
        String[] dayOfWeekInMonth = new String[6];
        int i2 = 0;
        while (i2 < dayOfWeekInMonth.length) {
            dayOfWeekInMonth[i2] = DayOfWeekInMonthConstant.typeToString(i2);
            this.cmbDayOfWeekInMonth.add(dayOfWeekInMonth[i2]);
            ++i2;
        }
        this.cmbDayOfWeekInMonth.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CalendarDetailDialog.this.update();
            }
        });
        this.cmbDayOfWeek = new Combo((Composite)this.groupDate, 133128);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.cmbDayOfWeek.setLayoutData((Object)gridData);
        String[] dayOfWeek = new String[7];
        int i3 = 0;
        while (i3 < dayOfWeek.length) {
            dayOfWeek[i3] = DayOfWeekConstant.typeToString(i3 + 1);
            this.cmbDayOfWeek.add(dayOfWeek[i3]);
            ++i3;
        }
        this.cmbDayOfWeek.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CalendarDetailDialog.this.update();
            }
        });
        label = new Label((Composite)this.groupDate, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.radioDate = new Button((Composite)this.groupDate, 16);
        this.radioDate.setText(Messages.getString((String)"monthday"));
        gridDataRadio = new GridData();
        gridDataRadio.horizontalSpan = 3;
        gridDataRadio.horizontalAlignment = 4;
        gridDataRadio.grabExcessHorizontalSpace = true;
        this.radioDate.setLayoutData((Object)gridDataRadio);
        this.radioDate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CalendarDetailDialog.this.update();
            }
        });
        this.cmbDays = new Combo((Composite)this.groupDate, 131080);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.cmbDays.setLayoutData((Object)gridData);
        String[] date = new String[31];
        int i4 = 0;
        while (i4 < date.length) {
            date[i4] = String.valueOf(i4 + 1);
            this.cmbDays.add(date[i4]);
            ++i4;
        }
        this.cmbDays.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CalendarDetailDialog.this.update();
            }
        });
        Label day = new Label((Composite)this.groupDate, 16384);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        day.setLayoutData((Object)gridData);
        day.setText(Messages.getString((String)"monthday"));
        label = new Label((Composite)this.groupDate, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.radioCalPattern = new Button((Composite)this.groupDate, 16);
        this.radioCalPattern.setText(Messages.getString((String)"calendar.pattern"));
        gridDataRadio = new GridData();
        gridDataRadio.horizontalSpan = 3;
        gridDataRadio.horizontalAlignment = 4;
        gridDataRadio.grabExcessHorizontalSpace = true;
        this.radioCalPattern.setLayoutData((Object)gridDataRadio);
        this.radioCalPattern.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CalendarDetailDialog.this.update();
            }
        });
        this.cmbCalPattern = new Combo((Composite)this.groupDate, 133128);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.cmbCalPattern.setLayoutData((Object)gridData);
        this.cmbCalPattern.add("");
        for (CalendarPatternInfo str : this.getCalendarPatternList(this.ownerRoleId)) {
            this.cmbCalPattern.add(str.getId());
        }
        this.cmbCalPattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CalendarDetailDialog.this.update();
            }
        });
        this.groupAfterDate = new Group(parent, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 8;
        this.groupAfterDate.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.groupAfterDate.setLayoutData((Object)gridData);
        this.groupAfterDate.setText(Messages.getString((String)"calendar.detail.before.after"));
        label = new Label((Composite)this.groupAfterDate, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"calendar.detail.after.1")));
        this.txtDaysLater = new Text((Composite)this.groupAfterDate, 133120);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.txtDaysLater.setLayoutData((Object)gridData);
        this.txtDaysLater.setTextLimit(8);
        this.txtDaysLater.setText("0");
        this.txtDaysLater.setToolTipText(String.valueOf(Messages.getString((String)"calendar.detail.notes")));
        this.txtDaysLater.addKeyListener((KeyListener)new NumberKeyListener());
        this.txtDaysLater.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                CalendarDetailDialog.this.update();
            }
        });
        label = new Label((Composite)this.groupAfterDate, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"calendar.detail.after.2")));
        this.groupTime = new Group(parent, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 8;
        this.groupTime.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.groupTime.setLayoutData((Object)gridData);
        this.groupTime.setText(Messages.getString((String)"time.period"));
        label = new Label((Composite)this.groupTime, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"start")) + Messages.getString((String)"timestamp"));
        this.txtTimeFrom = new Text((Composite)this.groupTime, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.txtTimeFrom.setLayoutData((Object)gridData);
        this.txtTimeFrom.setTextLimit(8);
        this.txtTimeFrom.setText("00:00:00");
        this.txtTimeFrom.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                CalendarDetailDialog.this.update();
            }
        });
        label = new Label((Composite)this.groupTime, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)this.groupTime, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"end")) + Messages.getString((String)"timestamp"));
        this.txtTimeTo = new Text((Composite)this.groupTime, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.txtTimeTo.setLayoutData((Object)gridData);
        this.txtTimeTo.setTextLimit(8);
        this.txtTimeTo.setText("24:00:00");
        this.txtTimeTo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                CalendarDetailDialog.this.update();
            }
        });
        this.groupOperate = new Group(parent, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 6;
        this.groupOperate.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.groupOperate.setLayoutData((Object)gridData);
        this.groupOperate.setText(Messages.getString((String)"calendar.detail.operation.3"));
        this.radioOperateON = new Button((Composite)this.groupOperate, 16);
        this.radioOperateON.setText(Messages.getString((String)"calendar.detail.operation.1"));
        this.radioOperateON.setSelection(true);
        gridDataRadio = new GridData();
        gridDataRadio.horizontalSpan = 2;
        gridDataRadio.horizontalAlignment = 4;
        gridDataRadio.grabExcessHorizontalSpace = true;
        this.radioOperateON.setLayoutData((Object)gridDataRadio);
        this.radioOperateOFF = new Button((Composite)this.groupOperate, 16);
        this.radioOperateOFF.setText(Messages.getString((String)"calendar.detail.operation.2"));
        gridDataRadio = new GridData();
        gridDataRadio.horizontalSpan = 2;
        gridDataRadio.horizontalAlignment = 4;
        gridDataRadio.grabExcessHorizontalSpace = true;
        this.radioOperateOFF.setLayoutData((Object)gridDataRadio);
        this.shell.pack();
        Display display = this.shell.getDisplay();
        this.shell.setLocation((display.getBounds().width - this.shell.getSize().x) / 2, (display.getBounds().height - this.shell.getSize().y) / 2);
        this.update();
        this.reflectCalendar();
    }

    public void update() {
        if (this.radioEveryYear.getSelection()) {
            this.txtYear.setEnabled(false);
        } else {
            this.txtYear.setEnabled(true);
        }
        if (this.radioAllDay.getSelection()) {
            this.cmbDayOfWeekInMonth.setEnabled(false);
            this.cmbDayOfWeek.setEnabled(false);
            this.cmbDays.setEnabled(false);
            this.txtDaysLater.setEnabled(false);
        } else {
            this.cmbDayOfWeekInMonth.setEnabled(true);
            this.cmbDayOfWeek.setEnabled(true);
            this.cmbDays.setEnabled(true);
            this.cmbCalPattern.setEnabled(true);
            this.txtDaysLater.setEnabled(true);
        }
        if (this.radioDayOfWeek.getSelection()) {
            this.cmbDayOfWeekInMonth.setEnabled(true);
            this.cmbDayOfWeek.setEnabled(true);
            this.cmbDays.setEnabled(false);
            this.cmbCalPattern.setEnabled(false);
        } else {
            this.cmbDayOfWeekInMonth.setEnabled(false);
            this.cmbDayOfWeek.setEnabled(false);
        }
        if (this.radioDate.getSelection()) {
            this.cmbDayOfWeekInMonth.setEnabled(false);
            this.cmbDayOfWeek.setEnabled(false);
            this.cmbDays.setEnabled(true);
            this.cmbCalPattern.setEnabled(false);
        } else {
            this.cmbDays.setEnabled(false);
        }
        if (this.radioCalPattern.getSelection()) {
            this.cmbDayOfWeekInMonth.setEnabled(false);
            this.cmbDayOfWeek.setEnabled(false);
            this.cmbDays.setEnabled(false);
            this.cmbCalPattern.setEnabled(true);
        } else {
            this.cmbCalPattern.setEnabled(false);
        }
        if (this.txtYear.getEnabled() && "".equals(this.txtYear.getText())) {
            this.txtYear.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.txtYear.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if (this.cmbDayOfWeekInMonth.getEnabled() && "".equals(this.cmbDayOfWeekInMonth.getText())) {
            this.cmbDayOfWeekInMonth.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.cmbDayOfWeekInMonth.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if (this.cmbDayOfWeek.getEnabled() && "".equals(this.cmbDayOfWeek.getText())) {
            this.cmbDayOfWeek.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.cmbDayOfWeek.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if (this.cmbDays.getEnabled() && "".equals(this.cmbDays.getText())) {
            this.cmbDays.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.cmbDays.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if (this.cmbCalPattern.getEnabled() && "".equals(this.cmbCalPattern.getText())) {
            this.cmbCalPattern.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.cmbCalPattern.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if ("".equals(this.txtTimeFrom.getText())) {
            this.txtTimeFrom.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.txtTimeFrom.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if ("".equals(this.txtTimeTo.getText())) {
            this.txtTimeTo.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.txtTimeTo.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
    }

    private CalendarDetailInfo createCalendarInfo() {
        Long timeTo;
        block33: {
            long hour48;
            block32: {
                Long timeFrom;
                block31: {
                    timeFrom = null;
                    timeTo = null;
                    this.inputData = new CalendarDetailInfo();
                    if (this.txtDescription.getText().length() > 0) {
                        this.inputData.setDescription(this.txtDescription.getText());
                    }
                    if (this.radioEveryYear.getSelection()) {
                        this.inputData.setYear(Integer.valueOf(0));
                    } else if (this.txtYear.getText() != null && this.txtYear.getText().length() > 0) {
                        try {
                            this.inputData.setYear(Integer.valueOf(Integer.parseInt(this.txtYear.getText())));
                        }
                        catch (NumberFormatException numberFormatException) {
                            Object[] args = new String[]{"[ " + Messages.getString((String)"year") + " ]"};
                            this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.calendar.51", (Object[])args));
                            return null;
                        }
                    } else {
                        Object[] args = new String[]{"[ " + Messages.getString((String)"year") + " ]"};
                        this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.calendar.15", (Object[])args));
                        return null;
                    }
                    if (this.cmbMonth.getText() == null || this.cmbMonth.getText().length() <= 0) {
                        Object[] args = new String[]{"[ " + Messages.getString((String)"month") + " ]"};
                        this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.calendar.15", (Object[])args));
                        return null;
                    }
                    this.inputData.setMonth(Integer.valueOf(MonthConstant.stringToType(this.cmbMonth.getText())));
                    if (this.radioAllDay.getSelection()) {
                        this.inputData.setDayType(Integer.valueOf(0));
                    } else if (this.radioDayOfWeek.getSelection()) {
                        if (this.cmbDayOfWeekInMonth.getText() == null || this.cmbDayOfWeekInMonth.getText().length() <= 0) {
                            Object[] args = new String[]{"[ " + Messages.getString((String)"calendar.detail.xth") + " ]"};
                            this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.calendar.15", (Object[])args));
                            return null;
                        }
                        this.inputData.setDayOfWeekInMonth(Integer.valueOf(DayOfWeekInMonthConstant.stringToType(this.cmbDayOfWeekInMonth.getText())));
                        if (this.cmbDayOfWeek.getText() == null || this.cmbDayOfWeek.getText().length() <= 0) {
                            Object[] args = new String[]{"[ " + Messages.getString((String)"weekday") + " ]"};
                            this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.calendar.15", (Object[])args));
                            return null;
                        }
                        this.inputData.setDayOfWeek(Integer.valueOf(DayOfWeekConstant.stringToType(this.cmbDayOfWeek.getText())));
                        this.inputData.setDayType(Integer.valueOf(1));
                    } else if (this.radioDate.getSelection()) {
                        if (this.cmbDays.getText() == null || this.cmbDays.getText().length() <= 0) {
                            Object[] args = new String[]{"[ " + Messages.getString((String)"monthday") + " ]"};
                            this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.calendar.15", (Object[])args));
                            return null;
                        }
                        this.inputData.setDate(Integer.valueOf(Integer.parseInt(this.cmbDays.getText())));
                        this.inputData.setDayType(Integer.valueOf(2));
                    } else if (this.radioCalPattern.getSelection()) {
                        if (this.cmbCalPattern.getText() == null || this.cmbCalPattern.getText().length() <= 0) {
                            Object[] args = new String[]{"[ " + Messages.getString((String)"calendar.pattern") + " ]"};
                            this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.calendar.15", (Object[])args));
                            return null;
                        }
                        this.inputData.setCalPatternId(this.cmbCalPattern.getText());
                        this.inputData.setDayType(Integer.valueOf(3));
                    } else {
                        Object[] args = new String[]{"[ " + Messages.getString((String)"calendar.detail.date.type") + " ]"};
                        this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.calendar.15", (Object[])args));
                        return null;
                    }
                    if (this.txtDaysLater.getText().length() > 0) {
                        int daysLater = 0;
                        try {
                            daysLater = Integer.parseInt(this.txtDaysLater.getText());
                        }
                        catch (Exception exception) {
                            Object[] args = new String[]{"[ " + Messages.getString((String)"calendar.detail.before.after") + " ]"};
                            this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.calendar.53", (Object[])args));
                            return null;
                        }
                        if (Short.MIN_VALUE > daysLater || daysLater > Short.MAX_VALUE) {
                            Object[] args = new String[]{Messages.getString((String)"calendar.detail.before.after"), "-32768", "32767"};
                            this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.calendar.52", (Object[])args));
                            return null;
                        }
                        this.inputData.setAfterday(Integer.valueOf(daysLater));
                    }
                    Date dateTimeFrom = null;
                    Date dateTimeTo = null;
                    try {
                        SimpleDateFormat sdfYmd = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                        String strHour48 = "1970/01/03 00:00:00";
                        Date date = sdfYmd.parse(strHour48);
                        hour48 = date.getTime();
                        dateTimeFrom = new SimpleDateFormat("HH:mm:ss").parse(this.txtTimeFrom.getText());
                        dateTimeTo = new SimpleDateFormat("HH:mm:ss").parse(this.txtTimeTo.getText());
                        timeFrom = dateTimeFrom.getTime();
                        timeTo = dateTimeTo.getTime();
                        if (timeFrom < hour48) break block31;
                        Object[] args = new String[]{"[ " + Messages.getString((String)"start") + Messages.getString((String)"time") + " ]", Messages.getString((String)"calendar.detail.hour48")};
                        this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.calendar.32", (Object[])args));
                        return null;
                    }
                    catch (ParseException parseException) {
                        String tmp = "";
                        tmp = dateTimeFrom == null ? "start" : "end";
                        this.setValidateResult(Messages.getString((String)"message.hinemos.1"), String.valueOf(Messages.getString((String)tmp)) + Messages.getString((String)"message.hinemos.6"));
                        return null;
                    }
                }
                this.inputData.setTimeFrom(timeFrom);
                if (timeFrom < timeTo) break block32;
                Object[] args = new String[]{"[ " + Messages.getString((String)"end") + Messages.getString((String)"time") + " ]", "[ " + Messages.getString((String)"start") + Messages.getString((String)"time") + " ]"};
                this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.calendar.31", (Object[])args));
                return null;
            }
            if (timeTo <= hour48) break block33;
            Object[] args = new String[]{"[ " + Messages.getString((String)"end") + Messages.getString((String)"time") + " ]", Messages.getString((String)"calendar.detail.hour48")};
            this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.calendar.33", (Object[])args));
            return null;
        }
        this.inputData.setTimeTo(timeTo);
        if (this.radioOperateON.getSelection()) {
            this.inputData.setOperateFlg(Boolean.valueOf(true));
        } else {
            this.inputData.setOperateFlg(Boolean.valueOf(false));
        }
        return this.inputData;
    }

    private void reflectCalendar() {
        CalendarDetailInfo detailInfo = null;
        detailInfo = this.inputData != null ? this.inputData : new CalendarDetailInfo();
        if (detailInfo != null) {
            Integer hh;
            String strHH;
            if (detailInfo.getDescription() != null) {
                this.txtDescription.setText(detailInfo.getDescription());
            }
            if (detailInfo.getYear() != null) {
                if (detailInfo.getYear() == 0) {
                    this.radioEveryYear.setSelection(true);
                    this.radioSpecifyYear.setSelection(false);
                } else {
                    this.radioSpecifyYear.setSelection(true);
                    this.radioEveryYear.setSelection(false);
                    this.txtYear.setText(String.valueOf(detailInfo.getYear()));
                }
            }
            if (detailInfo.getMonth() != null) {
                this.cmbMonth.setText(MonthConstant.typeToString(detailInfo.getMonth()));
            }
            if (detailInfo.getDayType() != null) {
                String str;
                if (detailInfo.getDayType() == 0) {
                    this.radioAllDay.setSelection(true);
                    this.radioDayOfWeek.setSelection(false);
                    this.radioDate.setSelection(false);
                    this.radioCalPattern.setSelection(false);
                } else if (detailInfo.getDayType() == 1) {
                    this.radioAllDay.setSelection(false);
                    this.radioDayOfWeek.setSelection(true);
                    this.radioDate.setSelection(false);
                    this.radioCalPattern.setSelection(false);
                } else if (detailInfo.getDayType() == 2) {
                    this.radioAllDay.setSelection(false);
                    this.radioDayOfWeek.setSelection(false);
                    this.radioDate.setSelection(true);
                    this.radioCalPattern.setSelection(false);
                } else if (detailInfo.getDayType() == 3) {
                    this.radioAllDay.setSelection(false);
                    this.radioDayOfWeek.setSelection(false);
                    this.radioDate.setSelection(false);
                    this.radioCalPattern.setSelection(true);
                } else {
                    m_log.error((Object)("Error Of DayType[" + detailInfo.getDayType() + "]"));
                }
                if (detailInfo.getDayOfWeekInMonth() != null) {
                    str = DayOfWeekInMonthConstant.typeToString(detailInfo.getDayOfWeekInMonth());
                    this.cmbDayOfWeekInMonth.setText(str);
                }
                if (detailInfo.getDayOfWeek() != null) {
                    str = DayOfWeekConstant.typeToString(detailInfo.getDayOfWeek());
                    this.cmbDayOfWeek.setText(str);
                }
                if (detailInfo.getDate() != null) {
                    this.cmbDays.setText(String.valueOf(detailInfo.getDate()));
                }
                if (detailInfo.getCalPatternId() != null) {
                    this.cmbCalPattern.setText(detailInfo.getCalPatternId());
                }
                if (detailInfo.getAfterday() != null) {
                    this.txtDaysLater.setText(String.valueOf(detailInfo.getAfterday()));
                }
            }
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
            SimpleDateFormat sdfYmd = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            SimpleDateFormat sdfHH = new SimpleDateFormat("HH");
            SimpleDateFormat sdfMmSs = new SimpleDateFormat("mm:ss");
            String strHour24 = "1970/01/02 00:00:00";
            String strHour48 = "1970/01/03 00:00:00";
            Date date = null;
            Date date2 = null;
            try {
                date = sdfYmd.parse(strHour24);
                date2 = sdfYmd.parse(strHour48);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            long hour24 = date.getTime();
            long hour48 = date2.getTime();
            if (detailInfo.getTimeFrom() != null) {
                if (hour48 <= detailInfo.getTimeFrom()) {
                    strHH = sdfHH.format(detailInfo.getTimeFrom());
                    hh = Integer.parseInt(strHH);
                    hh = hh + 48;
                    this.txtTimeFrom.setText(String.valueOf(String.valueOf(hh)) + ":" + sdfMmSs.format(detailInfo.getTimeFrom()));
                } else if (hour24 <= detailInfo.getTimeFrom()) {
                    strHH = sdfHH.format(detailInfo.getTimeFrom());
                    hh = Integer.parseInt(strHH);
                    hh = hh + 24;
                    this.txtTimeFrom.setText(String.valueOf(String.valueOf(hh)) + ":" + sdfMmSs.format(detailInfo.getTimeFrom()));
                } else {
                    this.txtTimeFrom.setText(sdf.format(detailInfo.getTimeFrom()));
                }
            }
            if (detailInfo.getTimeTo() != null) {
                if (hour48 <= detailInfo.getTimeTo()) {
                    strHH = sdfHH.format(detailInfo.getTimeTo());
                    hh = Integer.parseInt(strHH);
                    hh = hh + 48;
                    this.txtTimeTo.setText(String.valueOf(String.valueOf(hh)) + ":" + sdfMmSs.format(detailInfo.getTimeTo()));
                } else if (hour24 <= detailInfo.getTimeTo()) {
                    strHH = sdfHH.format(detailInfo.getTimeTo());
                    hh = Integer.parseInt(strHH);
                    hh = hh + 24;
                    this.txtTimeTo.setText(String.valueOf(String.valueOf(hh)) + ":" + sdfMmSs.format(detailInfo.getTimeTo()));
                } else {
                    this.txtTimeTo.setText(sdf.format(detailInfo.getTimeTo()));
                }
            }
            if (detailInfo.isOperateFlg() != null) {
                if (detailInfo.isOperateFlg().booleanValue()) {
                    this.radioOperateON.setSelection(true);
                    this.radioOperateOFF.setSelection(false);
                } else {
                    this.radioOperateON.setSelection(false);
                    this.radioOperateOFF.setSelection(true);
                }
            }
        }
        this.update();
    }

    @Override
    protected boolean action() {
        this.createCalendarInfo();
        return true;
    }

    @Override
    protected ValidateResult validate() {
        this.inputData = this.createCalendarInfo();
        if (this.inputData != null) {
            return super.validate();
        }
        return this.m_validateResult;
    }

    protected void setValidateResult(String id, String message) {
        this.m_validateResult = new ValidateResult();
        this.m_validateResult.setValid(false);
        this.m_validateResult.setID(id);
        this.m_validateResult.setMessage(message);
    }

    @Override
    protected String getOkButtonText() {
        return Messages.getString((String)"ok");
    }

    @Override
    protected String getCancelButtonText() {
        return Messages.getString((String)"cancel");
    }

    private List<CalendarPatternInfo> getCalendarPatternList(String ownerRoleId) {
        List<CalendarPatternInfo> calPatternList = null;
        try {
            calPatternList = CalendarEndpointWrapper.getCalendarPatternList(ownerRoleId);
        }
        catch (InvalidRole_Exception invalidRole_Exception) {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
        }
        catch (Exception e) {
            m_log.warn((Object)("update(), " + e.getMessage()), (Throwable)e);
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
            return null;
        }
        return calPatternList;
    }
}

