/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.calendar.view;

import com.clustercontrol.accesscontrol.util.ObjectBean;
import com.clustercontrol.calendar.composite.CalendarPatternComposite;
import com.clustercontrol.view.CommonViewPart;
import com.clustercontrol.view.ObjectPrivilegeTargetListView;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class CalendarPatternView
extends CommonViewPart
implements ObjectPrivilegeTargetListView {
    public static final String ID = "com.clustercontrol.calendar.view.CalendarPatternView";
    private CalendarPatternComposite m_calPatternComposite = null;
    private Composite m_parent = null;

    @Override
    public void createPartControl(Composite parent) {
        this.m_parent = parent;
        this.m_calPatternComposite = new CalendarPatternComposite(this.m_parent, 0);
        this.createContextMenu();
        this.update();
    }

    private void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                CalendarPatternView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuManager.createContextMenu((Control)this.m_calPatternComposite.getTable());
        this.m_calPatternComposite.getTable().setMenu(menu);
    }

    private void fillContextMenu(IMenuManager manager) {
        IToolBarManager toolbar = this.getViewSite().getActionBars().getToolBarManager();
        ActionContributionItem add = (ActionContributionItem)toolbar.find("com.clustercontrol.calendar.view.action.CalendarPatternAddAction");
        ActionContributionItem modify = (ActionContributionItem)toolbar.find("com.clustercontrol.calendar.view.action.CalendarPatternModifyAction");
        ActionContributionItem delete = (ActionContributionItem)toolbar.find("com.clustercontrol.calendar.view.action.CalendarPatternDeleteAction");
        ActionContributionItem copy = (ActionContributionItem)toolbar.find("com.clustercontrol.calendar.view.action.CalendarPatternCopyAction");
        ActionContributionItem objPrivilege = (ActionContributionItem)toolbar.find("com.clustercontrol.view.action.ObjectPrivilegeAction");
        manager.add(add.getAction());
        manager.add(modify.getAction());
        manager.add(delete.getAction());
        manager.add((IContributionItem)new Separator());
        manager.add(copy.getAction());
        manager.add((IContributionItem)new Separator());
        manager.add(objPrivilege.getAction());
    }

    @Override
    public void update() {
        this.m_calPatternComposite.update();
    }

    public String getSelectedId() {
        StructuredSelection selection = (StructuredSelection)this.m_calPatternComposite.getTableViewer().getSelection();
        List list = (List)selection.getFirstElement();
        String id = null;
        if (list != null) {
            id = (String)list.get(0);
        }
        return id;
    }

    @Override
    public List<ObjectBean> getSelectedObjectBeans() {
        StructuredSelection selection = (StructuredSelection)this.m_calPatternComposite.getTableViewer().getSelection();
        Object[] objs = selection.toArray();
        String objectType = "PLT_CAL_PTN";
        String objectId = null;
        ArrayList<ObjectBean> objectBeans = new ArrayList<ObjectBean>();
        Object[] objectArray = objs;
        int n = objs.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            objectId = (String)((List)obj).get(0);
            ObjectBean objectBean = new ObjectBean(objectType, objectId);
            objectBeans.add(objectBean);
            ++n2;
        }
        return objectBeans;
    }

    @Override
    public String getSelectedOwnerRoleId() {
        StructuredSelection selection = (StructuredSelection)this.m_calPatternComposite.getTableViewer().getSelection();
        List list = (List)selection.getFirstElement();
        String id = null;
        if (list != null) {
            id = (String)list.get(4);
        }
        return id;
    }

    public void setEnabledAction(int num, ISelection selection) {
        super.setEnabledAction("com.clustercontrol.calendar.view.action.CalendarPatternModifyAction", selection);
        super.setEnabledAction("com.clustercontrol.calendar.view.action.CalendarPatternDeleteAction", selection);
        super.setEnabledAction("com.clustercontrol.calendar.view.action.CalendarPatternCopyAction", selection);
        super.setEnabledAction("com.clustercontrol.view.action.ObjectPrivilegeAction", selection);
        if (num > 0) {
            super.setEnabledAction("com.clustercontrol.view.action.ObjectPrivilegeAction", true);
            super.setEnabledAction("com.clustercontrol.calendar.view.action.CalendarPatternModifyAction", true);
            super.setEnabledAction("com.clustercontrol.calendar.view.action.CalendarPatternDeleteAction", true);
            super.setEnabledAction("com.clustercontrol.calendar.view.action.CalendarPatternCopyAction", true);
        } else {
            super.setEnabledAction("com.clustercontrol.view.action.ObjectPrivilegeAction", false);
            super.setEnabledAction("com.clustercontrol.calendar.view.action.CalendarPatternModifyAction", false);
            super.setEnabledAction("com.clustercontrol.calendar.view.action.CalendarPatternDeleteAction", false);
            super.setEnabledAction("com.clustercontrol.calendar.view.action.CalendarPatternCopyAction", false);
        }
    }
}

