/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.collectiverun.composite;

import com.clustercontrol.ClusterControlPlugin;
import com.clustercontrol.accesscontrol.util.LocalSession;
import com.clustercontrol.bean.Property;
import com.clustercontrol.collectiverun.action.GetHistoryTableDefine;
import com.clustercontrol.collectiverun.composite.action.HistorySelectionChangedListener;
import com.clustercontrol.collectiverun.util.CollectiveRunEndpointWrapper;
import com.clustercontrol.collectiverun.util.HistoryFilterPropertyUtil;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.viewer.CommonTableViewer;
import com.clustercontrol.ws.collectiverun.HistoryFilterInfo;
import com.clustercontrol.ws.collectiverun.HistoryInfo;
import com.clustercontrol.ws.collectiverun.InvalidRole_Exception;
import com.clustercontrol.ws.collectiverun.ViewListInfo;
import com.sun.xml.internal.ws.client.ClientTransportException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class HistoryComposite
extends Composite {
    private static Log m_log = LogFactory.getLog(HistoryComposite.class);
    private CommonTableViewer m_viewer = null;
    private Label m_labelType = null;
    private Label m_labelCount = null;
    private String m_sessionId = null;

    public HistoryComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.m_labelType = new Label((Composite)this, 16384);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.m_labelType.setLayoutData((Object)gridData);
        Table table = new Table((Composite)this, 66308);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        table.setLayoutData((Object)gridData);
        this.m_labelCount = new Label((Composite)this, 131072);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.m_labelCount.setLayoutData((Object)gridData);
        this.m_viewer = new CommonTableViewer(table);
        this.m_viewer.createTableColumn(GetHistoryTableDefine.get(), GetHistoryTableDefine.SORT_COLUMN_INDEX, GetHistoryTableDefine.SORT_ORDER);
        this.update();
        this.m_viewer.addSelectionChangedListener(new HistorySelectionChangedListener(this));
    }

    public void update() {
        ViewListInfo historyInfo;
        block11: {
            historyInfo = null;
            try {
                int histories = ClusterControlPlugin.getDefault().getPreferenceStore().getInt("historyMaxHistories");
                historyInfo = CollectiveRunEndpointWrapper.getHistoryListAll(histories);
            }
            catch (InvalidRole_Exception e) {
                if (LocalSession.isDialogFlag()) {
                    LocalSession.setDialogFlag(false);
                    m_log.info((Object)("update(), " + e.getMessage()));
                    MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                    LocalSession.setDialogFlag(true);
                }
            }
            catch (Exception e) {
                if (!LocalSession.isDialogFlag()) break block11;
                LocalSession.setDialogFlag(false);
                if (e instanceof ClientTransportException) {
                    m_log.info((Object)("update() : " + e.getMessage()));
                    MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.transfer")) + ", " + e.getMessage()));
                } else {
                    m_log.warn((Object)("update() : " + e.getMessage()), (Throwable)e);
                    MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
                }
                LocalSession.setDialogFlag(true);
            }
        }
        if (historyInfo == null) {
            historyInfo = new ViewListInfo();
            historyInfo.setTotal(Integer.valueOf(0));
        }
        if (ClusterControlPlugin.getDefault().getPreferenceStore().getBoolean("historyMessageFlg") && historyInfo.getTotal() > historyInfo.getCollectiverunHistoryList().size() && LocalSession.isDialogFlag()) {
            LocalSession.setDialogFlag(false);
            MessageDialogWithToggle.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.job.33"), (String)Messages.getString((String)"message.will.not.be.displayed"), (boolean)false, (IPreferenceStore)ClusterControlPlugin.getDefault().getPreferenceStore(), (String)"historyMessageFlg");
            LocalSession.setDialogFlag(true);
        }
        ArrayList listInput = new ArrayList();
        for (HistoryInfo info : historyInfo.getCollectiverunHistoryList()) {
            ArrayList<Object> line = new ArrayList<Object>();
            line.add(info.getStatus());
            line.add(info.getSessionId());
            line.add(new Date(info.getStartDate()));
            if (info.getEndDate() == null) {
                line.add("");
            } else {
                line.add(new Date(info.getEndDate()));
            }
            line.add(info.getType());
            line.add(info.getName());
            line.add(info.getFacilityId());
            line.add(info.getScopeText());
            line.add(info.getNodeCount());
            line.add(info.getEndNormalCount());
            line.add(info.getEndWarningCount());
            line.add(info.getEndAbnormalCount());
            line.add(info.getWaitCount());
            line.add(info.getRunningCount());
            listInput.add(line);
        }
        this.m_viewer.setInput(listInput);
        this.selectHistory(historyInfo.getCollectiverunHistoryList());
        this.m_labelType.setText("");
        Object[] args = new Object[]{new Integer(historyInfo.getTotal())};
        this.m_labelCount.setText(Messages.getString((String)"records", (Object[])args));
    }

    public void update(Property condition) {
        ViewListInfo historyInfo;
        block13: {
            historyInfo = null;
            try {
                int histories = ClusterControlPlugin.getDefault().getPreferenceStore().getInt("historyMaxHistories");
                PropertyUtil.deletePropertyDefine(condition);
                HistoryFilterInfo filter = HistoryFilterPropertyUtil.property2dto(condition);
                historyInfo = CollectiveRunEndpointWrapper.getHistoryList(filter, histories);
            }
            catch (InvalidRole_Exception e) {
                if (LocalSession.isDialogFlag()) {
                    LocalSession.setDialogFlag(false);
                    m_log.info((Object)("update(), " + e.getMessage()));
                    MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                    LocalSession.setDialogFlag(true);
                }
            }
            catch (Exception e) {
                if (!LocalSession.isDialogFlag()) break block13;
                LocalSession.setDialogFlag(false);
                if (e instanceof ClientTransportException) {
                    m_log.info((Object)("update() : " + e.getMessage()));
                    MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.transfer")) + ", " + e.getMessage()));
                } else {
                    m_log.warn((Object)("update() : " + e.getMessage()), (Throwable)e);
                    MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
                }
                LocalSession.setDialogFlag(true);
            }
        }
        if (historyInfo == null) {
            historyInfo = new ViewListInfo();
        }
        if (ClusterControlPlugin.getDefault().getPreferenceStore().getBoolean("historyMessageFlg") && historyInfo.getTotal() > historyInfo.getCollectiverunHistoryList().size() && LocalSession.isDialogFlag()) {
            LocalSession.setDialogFlag(false);
            MessageDialogWithToggle.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.job.33"), (String)Messages.getString((String)"message.will.not.be.displayed"), (boolean)false, (IPreferenceStore)ClusterControlPlugin.getDefault().getPreferenceStore(), (String)"historyMessageFlg");
            LocalSession.setDialogFlag(true);
        }
        ArrayList listInput = new ArrayList();
        for (HistoryInfo info : historyInfo.getCollectiverunHistoryList()) {
            ArrayList<Object> line = new ArrayList<Object>();
            line.add(info.getStatus());
            line.add(info.getSessionId());
            if (info.getStartDate() != null) {
                line.add(new Date(info.getStartDate()));
            } else {
                line.add("");
            }
            if (info.getEndDate() != null) {
                line.add(new Date(info.getEndDate()));
            } else {
                line.add("");
            }
            line.add(info.getType());
            line.add(info.getName());
            line.add(info.getFacilityId());
            line.add(info.getScopeText());
            line.add(info.getNodeCount());
            line.add(info.getEndNormalCount());
            line.add(info.getEndWarningCount());
            line.add(info.getEndAbnormalCount());
            line.add(info.getWaitCount());
            line.add(info.getRunningCount());
            listInput.add(line);
        }
        this.m_viewer.setInput(listInput);
        this.selectHistory(historyInfo.getCollectiverunHistoryList());
        this.m_labelType.setText(Messages.getString((String)"filtered.list"));
        Object[] args = new Object[]{new Integer(historyInfo.getTotal())};
        this.m_labelCount.setText(Messages.getString((String)"filtered.records", (Object[])args));
    }

    public void selectHistory(List<HistoryInfo> list) {
        if (this.m_sessionId != null && this.m_sessionId.length() > 0) {
            int index = -1;
            HistoryInfo info = null;
            int i = 0;
            while (i < list.size()) {
                info = list.get(i);
                String sessionId = info.getSessionId();
                if (this.m_sessionId.compareTo(sessionId) == 0) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index == -1) {
                this.m_sessionId = null;
            } else {
                ArrayList<Object> line = new ArrayList<Object>();
                line.add(info.getStatus());
                line.add(info.getSessionId());
                if (info.getStartDate() != null) {
                    line.add(new Date(info.getStartDate()));
                } else {
                    line.add("");
                }
                if (info.getEndDate() != null) {
                    line.add(new Date(info.getEndDate()));
                } else {
                    line.add("");
                }
                line.add(info.getType());
                line.add(info.getName());
                line.add(info.getFacilityId());
                line.add(info.getScopeText());
                line.add(info.getNodeCount());
                line.add(info.getEndNormalCount());
                line.add(info.getEndWarningCount());
                line.add(info.getEndAbnormalCount());
                line.add(info.getWaitCount());
                line.add(info.getRunningCount());
                this.m_viewer.setSelection((ISelection)new StructuredSelection(line), true);
            }
        }
    }

    public CommonTableViewer getTableViewer() {
        return this.m_viewer;
    }

    public String getSessionId() {
        return this.m_sessionId;
    }

    public void setSessionId(String sessionId) {
        this.m_sessionId = sessionId;
    }
}

