/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.collectiverun.composite.action;

import com.clustercontrol.collectiverun.composite.TreeComposite;
import com.clustercontrol.collectiverun.util.TreeItemUtil;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.collectiverun.ItemInfo;
import com.clustercontrol.ws.collectiverun.TreeItem;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class CopyTreeItemAction
extends Action {
    private TreeComposite composite;

    public CopyTreeItemAction(TreeComposite composite) {
        this.composite = composite;
        this.setText(Messages.getString((String)"copy"));
        this.setToolTipText(Messages.getString((String)"copy"));
    }

    public void run() {
        TreeItem selectItem = this.composite.getSelectItem();
        if (selectItem instanceof TreeItem) {
            boolean copy = false;
            if (this.getInfo(selectItem).getType() == 0 || this.getInfo(selectItem).getType() == 1 || this.getInfo(selectItem).getType() == 2 || this.getInfo(selectItem).getType() == 3 || this.getInfo(selectItem).getType() == 4) {
                copy = true;
            }
            if (copy) {
                TreeItem copyItem = TreeItemUtil.copy(selectItem);
                TreeItem parent = selectItem.getParent();
                int maxOrderNo = TreeItemUtil.getMaxOrderNo(parent);
                ItemInfo copyInfo = this.getInfo(copyItem);
                copyInfo.setOrderNo(Integer.valueOf(maxOrderNo + 1));
                TreeItemUtil.addChildren(selectItem.getParent(), copyItem);
                this.composite.setCreateItem(copyItem);
                this.composite.getTreeViewer().refresh((Object)selectItem.getParent());
                this.composite.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)copyItem), true);
            }
        }
    }

    private ItemInfo getInfo(TreeItem item) {
        if (item.getCommandInfo() != null) {
            return item.getCommandInfo();
        }
        if (item.getCommandParameterInfo() != null) {
            return item.getCommandParameterInfo();
        }
        if (item.getParameterInfo() != null) {
            return item.getParameterInfo();
        }
        if (item.getParameterSelectInfo() != null) {
            return item.getParameterSelectInfo();
        }
        if (item.getTypeInfo() != null) {
            return item.getTypeInfo();
        }
        return null;
    }
}

