/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.collectiverun.composite.action;

import com.clustercontrol.collectiverun.composite.TreeComposite;
import com.clustercontrol.collectiverun.composite.action.BaseTreeItemSelectionListener;
import com.clustercontrol.collectiverun.util.CollectiveRunEndpointWrapper;
import com.clustercontrol.collectiverun.util.TreeItemUtil;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.collectiverun.InvalidRole_Exception;
import com.clustercontrol.ws.collectiverun.ItemInfo;
import com.clustercontrol.ws.collectiverun.TreeItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;

public class DeleteTreeItemSelectionListener
extends BaseTreeItemSelectionListener {
    private static Log m_log = LogFactory.getLog(DeleteTreeItemSelectionListener.class);

    public DeleteTreeItemSelectionListener(TreeComposite composite) {
        super(composite);
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        if (!this.checkCreateItem()) {
            return;
        }
        if (!this.checkUpdateItem()) {
            return;
        }
        TreeItem item = this.composite.getSelectItem();
        if (item instanceof TreeItem) {
            TreeItem parent = item.getParent();
            ItemInfo info = this.getInfo(item);
            ItemInfo parentInfo = this.getInfo(parent);
            if (info.getType() == -2 || info.getType() == -3) {
                return;
            }
            Object[] args = new Object[]{this.getInfo(item).getName()};
            if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)Messages.getString((String)"message.collective.run.10", (Object[])args))) {
                try {
                    CollectiveRunEndpointWrapper.deleteMaster(info, parentInfo);
                    TreeItemUtil.removeChildren(parent, item);
                    this.composite.setCreateItem(null);
                    this.composite.getTreeViewer().refresh((Object)parent);
                    this.composite.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)parent), true);
                }
                catch (Exception ex) {
                    if (ex instanceof InvalidRole_Exception) {
                        MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                    } else {
                        m_log.warn((Object)("widgetSelected(), " + ex.getMessage()), (Throwable)ex);
                        MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + ex.getMessage()));
                    }
                    this.composite.getTreeViewer().refresh((Object)parent);
                    this.composite.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)item), true);
                }
            }
        }
    }

    private ItemInfo getInfo(TreeItem item) {
        if (item.getCommandInfo() != null) {
            return item.getCommandInfo();
        }
        if (item.getCommandParameterInfo() != null) {
            return item.getCommandParameterInfo();
        }
        if (item.getParameterInfo() != null) {
            return item.getParameterInfo();
        }
        if (item.getParameterSelectInfo() != null) {
            return item.getParameterSelectInfo();
        }
        if (item.getTypeInfo() != null) {
            return item.getTypeInfo();
        }
        return null;
    }
}

