/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.collectiverun.composite.action;

import com.clustercontrol.collectiverun.composite.TreeComposite;
import com.clustercontrol.collectiverun.composite.action.BaseTreeItemSelectionListener;
import com.clustercontrol.collectiverun.util.CollectiveRunEndpointWrapper;
import com.clustercontrol.collectiverun.util.TreeItemUtil;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.collectiverun.InvalidRole_Exception;
import com.clustercontrol.ws.collectiverun.ItemInfo;
import com.clustercontrol.ws.collectiverun.TreeItem;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;

public class UpDownTreeItemSelectionListener
extends BaseTreeItemSelectionListener {
    private boolean up;

    public UpDownTreeItemSelectionListener(TreeComposite composite, boolean up) {
        super(composite);
        this.up = up;
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        if (!this.checkCreateItem()) {
            return;
        }
        if (!this.checkUpdateItem()) {
            return;
        }
        TreeItem item = this.composite.getSelectItem();
        TreeItem parent = item.getParent();
        if (!(item instanceof TreeItem) || !(parent instanceof TreeItem)) {
            return;
        }
        TreeItem target = null;
        target = this.up ? TreeItemUtil.getUpDownTargetItem(item, true) : TreeItemUtil.getUpDownTargetItem(item, false);
        if (!(target instanceof TreeItem)) {
            return;
        }
        ItemInfo info = this.getInfo(item);
        ItemInfo parentInfo = this.getInfo(parent);
        ItemInfo targetInfo = this.getInfo(target);
        try {
            CollectiveRunEndpointWrapper.changeOrder(info, targetInfo, parentInfo);
            int orderNo = info.getOrderNo();
            info.setOrderNo(targetInfo.getOrderNo());
            targetInfo.setOrderNo(Integer.valueOf(orderNo));
            this.composite.setCreateItem(null);
            this.composite.setUpdateItem(null);
            this.composite.getTreeViewer().refresh((Object)parent);
            this.composite.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)item), true);
        }
        catch (Exception ex) {
            String errMessage = "";
            if (ex instanceof InvalidRole_Exception) {
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
            } else {
                errMessage = ", " + ex.getMessage();
            }
            Object[] args = new Object[]{info.getName(), targetInfo.getName()};
            MessageDialog.openError(null, (String)Messages.getString((String)"message"), (String)(String.valueOf(Messages.getString((String)"message.collective.run.15", (Object[])args)) + errMessage));
            return;
        }
    }

    private ItemInfo getInfo(TreeItem item) {
        if (item.getCommandInfo() != null) {
            return item.getCommandInfo();
        }
        if (item.getCommandParameterInfo() != null) {
            return item.getCommandParameterInfo();
        }
        if (item.getParameterInfo() != null) {
            return item.getParameterInfo();
        }
        if (item.getParameterSelectInfo() != null) {
            return item.getParameterSelectInfo();
        }
        if (item.getTypeInfo() != null) {
            return item.getTypeInfo();
        }
        return null;
    }
}

