/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.collectiverun.util;

import com.clustercontrol.util.EndpointManager;
import com.clustercontrol.ws.collectiverun.CollectiveRunEndpoint;
import com.clustercontrol.ws.collectiverun.CollectiveRunInfo;
import com.clustercontrol.ws.collectiverun.CollectiveRunNotFound_Exception;
import com.clustercontrol.ws.collectiverun.CommandInfo;
import com.clustercontrol.ws.collectiverun.CommandParameterInfo;
import com.clustercontrol.ws.collectiverun.CommandTypeInfo;
import com.clustercontrol.ws.collectiverun.DetailInfo;
import com.clustercontrol.ws.collectiverun.FacilityNotFound_Exception;
import com.clustercontrol.ws.collectiverun.HashMapInfo;
import com.clustercontrol.ws.collectiverun.HinemosUnknown_Exception;
import com.clustercontrol.ws.collectiverun.HistoryFilterInfo;
import com.clustercontrol.ws.collectiverun.InvalidRole_Exception;
import com.clustercontrol.ws.collectiverun.InvalidSetting_Exception;
import com.clustercontrol.ws.collectiverun.InvalidUserPass_Exception;
import com.clustercontrol.ws.collectiverun.ItemInfo;
import com.clustercontrol.ws.collectiverun.ParameterSelectInfo;
import com.clustercontrol.ws.collectiverun.SessionInfo;
import com.clustercontrol.ws.collectiverun.TreeItem;
import com.clustercontrol.ws.collectiverun.ViewListInfo;
import com.sun.xml.internal.ws.client.ClientTransportException;
import java.util.List;
import javax.xml.ws.WebServiceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CollectiveRunEndpointWrapper {
    private static Log m_log = LogFactory.getLog(CollectiveRunEndpointWrapper.class);

    public static void deleteMaster(ItemInfo info, ItemInfo parentInfo) throws CollectiveRunNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getCollectiveRunEndpoint()) {
            try {
                CollectiveRunEndpoint endpoint = (CollectiveRunEndpoint)endpointSetting.getEndpoint();
                endpoint.deleteMaster(info, parentInfo);
                return;
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("deleteMaster(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static void run(String typeId, CollectiveRunInfo collectiveRunInfo) throws CollectiveRunNotFound_Exception, FacilityNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, InvalidSetting_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getCollectiveRunEndpoint()) {
            try {
                CollectiveRunEndpoint endpoint = (CollectiveRunEndpoint)endpointSetting.getEndpoint();
                endpoint.run(typeId, collectiveRunInfo);
                return;
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("run(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static List<DetailInfo> getDetailList(String sessionId) throws CollectiveRunNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getCollectiveRunEndpoint()) {
            try {
                CollectiveRunEndpoint endpoint = (CollectiveRunEndpoint)endpointSetting.getEndpoint();
                return endpoint.getDetailList(sessionId);
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getDetailList(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static ViewListInfo getHistoryListAll(int count) throws CollectiveRunNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getCollectiveRunEndpoint()) {
            try {
                CollectiveRunEndpoint endpoint = (CollectiveRunEndpoint)endpointSetting.getEndpoint();
                return endpoint.getHistoryListAll(count);
            }
            catch (WebServiceException e) {
                wse = e;
                if (e instanceof ClientTransportException) {
                    m_log.warn((Object)("getHistoryListAll(), " + e.getMessage()));
                } else {
                    m_log.warn((Object)("getHistoryListAll(), " + e.getMessage()), (Throwable)e);
                }
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static ViewListInfo getHistoryList(HistoryFilterInfo historyFilterInfo, int count) throws CollectiveRunNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getCollectiveRunEndpoint()) {
            try {
                CollectiveRunEndpoint endpoint = (CollectiveRunEndpoint)endpointSetting.getEndpoint();
                return endpoint.getHistoryList(historyFilterInfo, count);
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getHistoryList(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static String getParameterTypeId(String sessionId) throws FacilityNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getCollectiveRunEndpoint()) {
            try {
                CollectiveRunEndpoint endpoint = (CollectiveRunEndpoint)endpointSetting.getEndpoint();
                return endpoint.getParameterTypeId(sessionId);
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getParameterTypeId(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static TreeItem getTree() throws CollectiveRunNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getCollectiveRunEndpoint()) {
            try {
                CollectiveRunEndpoint endpoint = (CollectiveRunEndpoint)endpointSetting.getEndpoint();
                TreeItem item = endpoint.getTree();
                CollectiveRunEndpointWrapper.setTreeParent(item);
                return item;
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getTree(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    private static void setTreeParent(TreeItem item) {
        List children = item.getChildren();
        for (TreeItem child : children) {
            child.setParent(item);
            CollectiveRunEndpointWrapper.setTreeParent(child);
        }
    }

    public static HashMapInfo getTypeHashMap() throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getCollectiveRunEndpoint()) {
            try {
                CollectiveRunEndpoint endpoint = (CollectiveRunEndpoint)endpointSetting.getEndpoint();
                return endpoint.getTypeHashMap();
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getTypeHashMap(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static List<String> getTypeStringList() throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getCollectiveRunEndpoint()) {
            try {
                CollectiveRunEndpoint endpoint = (CollectiveRunEndpoint)endpointSetting.getEndpoint();
                return endpoint.getTypeStringList();
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getTypeStringList(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static void updateMaster(ItemInfo info, ItemInfo parentInfo) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getCollectiveRunEndpoint()) {
            try {
                CollectiveRunEndpoint endpoint = (CollectiveRunEndpoint)endpointSetting.getEndpoint();
                endpoint.updateMaster(info, parentInfo);
                return;
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("updateMaster(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static void changeOrder(ItemInfo info1, ItemInfo info2, ItemInfo parentInfo) throws CollectiveRunNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getCollectiveRunEndpoint()) {
            try {
                CollectiveRunEndpoint endpoint = (CollectiveRunEndpoint)endpointSetting.getEndpoint();
                endpoint.changeOrder(info1, info2, parentInfo);
                return;
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("changeOrder(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static SessionInfo getSessionInfo(String sessionId) throws CollectiveRunNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getCollectiveRunEndpoint()) {
            try {
                CollectiveRunEndpoint endpoint = (CollectiveRunEndpoint)endpointSetting.getEndpoint();
                return endpoint.getSessionInfo(sessionId);
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getSessionInfo(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static CommandInfo getCommandMst(String commandId) throws CollectiveRunNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getCollectiveRunEndpoint()) {
            try {
                CollectiveRunEndpoint endpoint = (CollectiveRunEndpoint)endpointSetting.getEndpoint();
                return endpoint.getCommandMst(commandId);
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getCommandMst(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static CommandTypeInfo getCommandTypeMst(String typeId) throws CollectiveRunNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getCollectiveRunEndpoint()) {
            try {
                CollectiveRunEndpoint endpoint = (CollectiveRunEndpoint)endpointSetting.getEndpoint();
                return endpoint.getCommandTypeMst(typeId);
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getCommandTypeMst(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static List<CommandParameterInfo> getCommandParameterMstList(String id) throws CollectiveRunNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getCollectiveRunEndpoint()) {
            try {
                CollectiveRunEndpoint endpoint = (CollectiveRunEndpoint)endpointSetting.getEndpoint();
                return endpoint.getCommandParameterMstList(id);
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getCommandParameterMstList(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static Integer getParameterType(String id) throws CollectiveRunNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getCollectiveRunEndpoint()) {
            try {
                CollectiveRunEndpoint endpoint = (CollectiveRunEndpoint)endpointSetting.getEndpoint();
                return endpoint.getParameterType(id);
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getParameterType(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static List<ParameterSelectInfo> getParameterSelectMstList(String paramId) throws CollectiveRunNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getCollectiveRunEndpoint()) {
            try {
                CollectiveRunEndpoint endpoint = (CollectiveRunEndpoint)endpointSetting.getEndpoint();
                return endpoint.getParameterSelectMstList(paramId);
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getParameterSelectMstList(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static String getCommandId(String typeId, String name) throws CollectiveRunNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getCollectiveRunEndpoint()) {
            try {
                CollectiveRunEndpoint endpoint = (CollectiveRunEndpoint)endpointSetting.getEndpoint();
                return endpoint.getCommandId(typeId, name);
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getCommandId(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }
}

