/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.collectiverun.util;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyDefineConstant;
import com.clustercontrol.bean.PropertyTreeItem;
import com.clustercontrol.collectiverun.bean.EditorTypeConstant;
import com.clustercontrol.collectiverun.util.CollectiveRunEndpointWrapper;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.ws.collectiverun.CommandInfo;
import com.clustercontrol.ws.collectiverun.CommandParameterInfo;
import com.clustercontrol.ws.collectiverun.CommandTypeInfo;
import com.clustercontrol.ws.collectiverun.InvalidRole_Exception;
import com.clustercontrol.ws.collectiverun.ParameterInfo;
import com.clustercontrol.ws.collectiverun.ParameterSelectInfo;
import com.clustercontrol.ws.collectiverun.SessionInfo;
import com.clustercontrol.ws.collectiverun.SessionParameterInfo;
import com.clustercontrol.ws.repository.FacilityInfo;
import com.clustercontrol.ws.repository.FacilityTreeItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;

public class ParameterPropertyUtil {
    private static Log m_log = LogFactory.getLog(ParameterPropertyUtil.class);
    private static final Integer FACILITY_TYPE_DEFAULT = 1;
    private static final Integer DISPLAY_SORT_ORDER_DEFAULT = 100;

    public static Property getPropertyBySessionId(String sessionId, Locale locale) throws InvalidRole_Exception {
        SessionInfo sessionInfo = null;
        CommandInfo commandMst = null;
        try {
            sessionInfo = CollectiveRunEndpointWrapper.getSessionInfo(sessionId);
            commandMst = CollectiveRunEndpointWrapper.getCommandMst(sessionInfo.getCommandId());
        }
        catch (InvalidRole_Exception e) {
            throw e;
        }
        catch (Exception e) {
            m_log.warn((Object)("getPropertyBySessionId(), " + e.getMessage()), (Throwable)e);
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
        }
        Property property = null;
        property = ParameterPropertyUtil.getParameterProperty(commandMst.getCommandTypeId(), locale);
        if (property instanceof Property) {
            ParameterPropertyUtil.selectNameProperty(property, Messages.getString((String)commandMst.getName(), (Locale)locale), locale);
            ParameterPropertyUtil.setPropertyValue(property, sessionInfo, locale);
        }
        return property;
    }

    private static Property getCommandParameterProperty(CommandParameterInfo cmdParam, Locale locale) throws NamingException {
        Property parameter = null;
        if (cmdParam != null) {
            List paramSelectList;
            ParameterInfo param = cmdParam.getParamMst();
            int paramType = param.getParamType();
            parameter = new Property(param.getId(), Messages.getString((String)param.getName(), (Locale)locale), EditorTypeConstant.paramTypeToEditor(paramType));
            if (paramType == 0 || paramType == 1) {
                parameter.setStringUpperValue(4096);
            }
            parameter.setModify(1);
            parameter.setValue("");
            if (paramType == 2 && (paramSelectList = param.getSelectMsts()) != null && paramSelectList.size() > 0) {
                Object[][] selectValues = new Object[][]{new Object[paramSelectList.size()], new Object[paramSelectList.size()]};
                for (ParameterSelectInfo paramSelect : paramSelectList) {
                    int index = paramSelect.getOrderNo();
                    selectValues[1][index] = Messages.getString((String)paramSelect.getName(), (Locale)locale);
                    selectValues[0][index] = Messages.getString((String)paramSelect.getName(), (Locale)locale);
                }
                parameter.setSelectValues(selectValues);
                parameter.setValue(selectValues[0][0]);
            }
        }
        return parameter;
    }

    public static Property getParameterProperty(String typeId, Locale locale) throws InvalidRole_Exception {
        Property scope = new Property("scope", Messages.getString((String)"scope", (Locale)locale), PropertyDefineConstant.EDITOR_FACILITY);
        scope.setModify(1);
        Property name = new Property("name", Messages.getString((String)"name", (Locale)locale), PropertyDefineConstant.EDITOR_SELECT);
        name.setModify(1);
        CommandTypeInfo cmdTypeMst = null;
        try {
            cmdTypeMst = CollectiveRunEndpointWrapper.getCommandTypeMst(typeId);
        }
        catch (InvalidRole_Exception e) {
            throw e;
        }
        catch (Exception e) {
            m_log.warn((Object)("getParameterProperty(), " + e.getMessage()), (Throwable)e);
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
        }
        HashMap<String, Property> propertyMap = new HashMap<String, Property>();
        List cmdList = cmdTypeMst.getCmdMsts();
        if (cmdList != null && cmdList.size() > 0) {
            Object[][] nameValues = new Object[][]{new Object[cmdList.size()], new Object[cmdList.size()]};
            for (CommandInfo cmd : cmdList) {
                int index = cmd.getOrderNo();
                ArrayList<Property> list = new ArrayList<Property>();
                List<CommandParameterInfo> cmdParamList = null;
                try {
                    cmdParamList = CollectiveRunEndpointWrapper.getCommandParameterMstList(cmd.getId());
                }
                catch (InvalidRole_Exception e) {
                    throw e;
                }
                catch (Exception e) {
                    m_log.warn((Object)("getParameterProperty() getCommandParameterMstList, " + e.getMessage()), (Throwable)e);
                    MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
                }
                if (cmdParamList != null && cmdParamList.size() > 0) {
                    for (CommandParameterInfo cmdParam : cmdParamList) {
                        Property parameter = null;
                        try {
                            parameter = ParameterPropertyUtil.getCommandParameterProperty(cmdParam, locale);
                        }
                        catch (NamingException namingException) {}
                        if (propertyMap.get(cmdParam.getId()) == null) {
                            list.add(parameter);
                            propertyMap.put(cmdParam.getId(), parameter);
                            continue;
                        }
                        list.add((Property)propertyMap.get(cmdParam.getId()));
                    }
                }
                nameValues[0][index] = Messages.getString((String)cmd.getName(), (Locale)locale);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("value", Messages.getString((String)cmd.getName(), (Locale)locale));
                map.put("property", list);
                nameValues[1][index] = map;
            }
            name.setSelectValues(nameValues);
            name.setValue(nameValues[1][0]);
        }
        Property property = new Property(null, null, "");
        property.removeChildren();
        property.addChildren(scope);
        property.addChildren(name);
        Object[][] nameValues = name.getSelectValues();
        ParameterPropertyUtil.selectNameProperty(property, (String)nameValues[0][0], locale);
        return property;
    }

    private static void selectNameProperty(Property property, String dispText, Locale locale) {
        int index = 0;
        Property name = null;
        ArrayList<Property> properties = null;
        properties = PropertyUtil.getProperty(property, "name");
        if (properties != null) {
            name = properties.get(0);
        }
        if (name instanceof Property) {
            Object[][] nameValues = name.getSelectValues();
            if (dispText != null) {
                int i = 0;
                while (i < nameValues[0].length) {
                    if (dispText.compareTo((String)nameValues[0][i]) == 0) {
                        index = i;
                        break;
                    }
                    ++i;
                }
            }
            if (nameValues[1][index] instanceof HashMap) {
                HashMap map = (HashMap)nameValues[1][index];
                name.setValue(map.get("value"));
                ArrayList propertyList = (ArrayList)map.get("property");
                if (propertyList != null) {
                    name.removeChildren();
                    int i = 0;
                    while (i < propertyList.size()) {
                        name.addChildren((PropertyTreeItem)propertyList.get(i));
                        ++i;
                    }
                }
            } else {
                name.removeChildren();
                Object select = nameValues[1][index];
                name.setValue(select);
            }
        }
    }

    private static void setPropertyValue(Property property, SessionInfo session, Locale locale) throws InvalidRole_Exception {
        ArrayList<Property> properties = PropertyUtil.getProperty(property, "scope");
        properties.get(0).setValue("");
        FacilityTreeItem item = null;
        FacilityInfo info = new FacilityInfo();
        info.setValid(Boolean.valueOf(true));
        info.setCreateDatetime(Long.valueOf(System.currentTimeMillis()));
        info.setModifyDatetime(Long.valueOf(System.currentTimeMillis()));
        info.setBuiltInFlg(Boolean.valueOf(false));
        info.setFacilityType(FACILITY_TYPE_DEFAULT);
        info.setDisplaySortOrder(DISPLAY_SORT_ORDER_DEFAULT);
        info.setFacilityId(session.getFacilityId());
        info.setFacilityName(session.getScopeText());
        item = new FacilityTreeItem();
        item.setParent(null);
        item.setData(info);
        properties.get(0).setValue(item);
        List paramList = session.getParams();
        if (paramList != null && paramList.size() > 0) {
            for (SessionParameterInfo paramInfo : paramList) {
                properties = PropertyUtil.getProperty(property, paramInfo.getId());
                properties.get(0).setValue("");
                try {
                    Integer paramType = CollectiveRunEndpointWrapper.getParameterType(paramInfo.getId());
                    if (paramInfo.getValue() == null) continue;
                    if (paramType == 2) {
                        properties.get(0).setValue(ParameterPropertyUtil.getParamValue(paramInfo.getId(), paramInfo.getValue(), locale));
                        continue;
                    }
                    properties.get(0).setValue(paramInfo.getValue());
                }
                catch (InvalidRole_Exception e) {
                    throw e;
                }
                catch (Exception e) {
                    m_log.warn((Object)("setPropertyValue(), " + e.getMessage()), (Throwable)e);
                    MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
                }
            }
        }
    }

    private static String getParamValue(String paramId, String value, Locale locale) throws InvalidRole_Exception {
        String name = null;
        List<ParameterSelectInfo> paramSelectList = null;
        try {
            paramSelectList = CollectiveRunEndpointWrapper.getParameterSelectMstList(paramId);
        }
        catch (InvalidRole_Exception e) {
            throw e;
        }
        catch (Exception e) {
            m_log.warn((Object)("getParamValue(), " + e.getMessage()), (Throwable)e);
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
        }
        if (paramSelectList != null && paramSelectList.size() > 0) {
            for (ParameterSelectInfo paramSelect : paramSelectList) {
                if (!paramSelect.getValue().equals(value)) continue;
                name = Messages.getString((String)paramSelect.getName(), (Locale)locale);
                break;
            }
        }
        return name;
    }
}

