/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.composite.action;

import com.clustercontrol.util.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Text;

public class NumberVerifyListener
implements VerifyListener {
    private Integer low;
    private Integer high;

    public NumberVerifyListener() {
        this.low = null;
        this.high = null;
    }

    public NumberVerifyListener(int low, int high) {
        this.low = low;
        this.high = high;
    }

    public Integer getHigh() {
        return this.high;
    }

    public void setHigh(Integer high) {
        this.high = high;
    }

    public Integer getLow() {
        return this.low;
    }

    public void setLow(Integer low) {
        this.low = low;
    }

    public void verifyText(VerifyEvent e) {
        Text text = (Text)e.getSource();
        StringBuilder input = new StringBuilder(text.getText());
        if (e.keyCode == 0) {
            input.replace(e.start, e.end, e.text);
        } else if (e.character == '\b' || e.character == '\u007f') {
            input.delete(e.start, e.end);
        } else {
            input.replace(e.start, e.end, e.text);
        }
        if (input.toString().matches("-")) {
            return;
        }
        if (!input.toString().matches("-?\\d*")) {
            e.doit = false;
            return;
        }
        this.checkRange(e, input.toString());
    }

    protected void checkRange(VerifyEvent e, String inputText) {
        try {
            if (inputText.length() == 0) {
                return;
            }
            if (this.low == null || this.high == null) {
                return;
            }
            Integer input = Integer.valueOf(inputText.toString());
            if (input.compareTo(this.low) < 0 || input.compareTo(this.high) > 0) {
                e.doit = false;
                Object[] args = new String[]{this.low.toString(), this.high.toString()};
                MessageDialog.openWarning(null, (String)Messages.getString((String)"message.hinemos.1"), (String)Messages.getString((String)"message.hinemos.8", (Object[])args));
            }
        }
        catch (NumberFormatException numberFormatException) {
            e.doit = false;
        }
    }
}

