/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.composite.action;

import com.clustercontrol.util.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Text;

public class TimeVerifyListener
implements VerifyListener {
    private static final String NUMBER_CHAR = "0123456789:";
    private static final String COLON_CHAR = ":";
    private static final Integer LENGTH = 8;

    public void verifyText(VerifyEvent e) {
        Text text = (Text)e.getSource();
        StringBuilder input = new StringBuilder(text.getText());
        if (e.keyCode == 0) {
            input.replace(e.start, e.end, e.text);
        } else if (e.character == '\b' || e.character == '\u007f') {
            input.delete(e.start, e.end);
        } else {
            if (NUMBER_CHAR.indexOf(Character.toString(e.character)) == -1) {
                e.doit = false;
                return;
            }
            if (COLON_CHAR.indexOf(Character.toString(e.character)) == 0) {
                if (text.getText().length() == 0) {
                    e.doit = false;
                }
                return;
            }
            input.replace(e.start, e.end, e.text);
        }
        this.checkRange(e, input.toString());
    }

    private void checkRange(VerifyEvent e, String inputText) {
        if (inputText.length() > LENGTH) {
            e.doit = false;
            Object[] args = new String[]{LENGTH.toString()};
            MessageDialog.openWarning(null, (String)Messages.getString((String)"message.hinemos.1"), (String)Messages.getString((String)"message.hinemos.7", (Object[])args));
        }
    }
}

